import aiohttp_jinja2
from aiohttp import web

from ...misc.defaults import STATUS_UNKNOWN, STATUS_FINISHED, STATUS_ERROR, STATUS_PASSED, STATUS_PENDING


class ServiceDetailBackupVersionView(web.View):
    @aiohttp_jinja2.template('backup_version_detail.jinja2')
    async def get(self):
        db = self.request.app['db']
        service = self.request.match_info['service_name']
        # db = app["db"]

        s_id = await db.fetchval('''SELECT s_id FROM services WHERE service =$1''', service)

        rows_services_meta = await db.fetch(
            '''SELECT * FROM services_meta WHERE service_id=$1''', s_id)

        version_status_d = {}

        for row_m in rows_services_meta:
            version = row_m["version"]

            version_status_d[version] = {}
            version_status_d[version]["status"] = STATUS_UNKNOWN

            tbl = f"{service}_{version}"

            rows_info = await db.fetch(
                '''SELECT status FROM {infotable}'''.format(infotable=tbl)
            )

            stat_dict = {"status": STATUS_UNKNOWN,
                         STATUS_FINISHED: [],
                         STATUS_ERROR: [],
                         STATUS_PASSED: [],
                         STATUS_PENDING: []}

            for row_i in rows_info:
                if (dict(row_i))['status'] == STATUS_FINISHED:
                    stat_dict[STATUS_FINISHED].append(dict(row_i))
                if (dict(row_i))['status'] == STATUS_ERROR:
                    stat_dict[STATUS_ERROR].append(dict(row_i))
                if (dict(row_i))['status'] == STATUS_PASSED:
                    stat_dict[STATUS_PASSED].append(dict(row_i))
                if (dict(row_i))['status'] == STATUS_PENDING:
                    stat_dict[STATUS_PENDING].append(dict(row_i))

            if len(stat_dict[STATUS_ERROR]) != 0:
                version_status_d[version] = STATUS_ERROR
            elif len(stat_dict[STATUS_PENDING]) != 0:
                version_status_d[version] = STATUS_PENDING
            elif (len(stat_dict[STATUS_FINISHED]) != 0) or (len(stat_dict[STATUS_PASSED]) != 0):
                version_status_d[version] = STATUS_FINISHED

        # print(version_status_d)
        return {"rows": rows_services_meta,
                "service": service,
                "state": version_status_d}
