# -*- coding: utf-8 -*-


class BackpackAPIError(Exception):
    pass


class BackpackAPIResultError(Exception):
    def __init__(self, code, message, *args):
        super(BackpackAPIResultError, self).__init__(message.format(*args) if args else message)
        self.code = code


class BackpackAPIClientError(BackpackAPIError):
    pass


class BackpackAPIServerError(BackpackAPIError):
    pass


class BackpackAPIServerSoftError(BackpackAPIServerError):
    pass


class BackpackAPIServerHardError(BackpackAPIServerError):
    pass


class BackpackAPIWireError(BackpackAPIClientError):
    pass


class BackpackAPIConnectError(BackpackAPIWireError):
    pass


class BackpackAPIEncodeError(BackpackAPIClientError):
    pass


class BackpackAPIDecodeError(BackpackAPIClientError):
    pass
