def get_searchmap_parsed(searchmap_path):
    """
    :param searchmap_url:string
    :return: list[dict[service][iNum][{host:port},{host2:port2}...],dict[service2][iNum2][{host:{port}, {host2:port2}..]]
    """

    with open(searchmap_path, 'r') as f:
        searchmap_unparsed = f.readlines()

    return_dict = {}
    for line in searchmap_unparsed:
        if not line or not line.strip():
            continue
        if line.startswith("#"):
            continue
        # Get iNum
        services = line.split(" ")[0].split(",")
        for service in services:
            if not return_dict.get(service):
                return_dict[service] = {}
            line_data = line.split(" ")[1].split(",")
            line_dict = {}

            for el in line_data:
                if el.startswith("zk:"):
                    line_dict["zk"] = el.split("zk:")[1]
                else:
                    line_dict[el.split(":")[0]] = el.split(":")[1]

            if not line_dict.get("zk"):
                line_dict["zk"] = ""

            iNum = "{0}:{1}".format("iNum", line_dict['iNum'])
            host = line_dict['host']
            search_port = line_dict['search_port']
            zks = line_dict["zk"]
            shards = line_dict["shards"]
            if not return_dict[service].get(iNum):
                return_dict[service][iNum] = []
            return_dict[service][iNum].append({"hostname": host,
                                               "search_port": search_port,
                                               "zk": zks,
                                               "shards": shards})
    return return_dict
