#!/bin/bash
rm -rf build

virtualenv --prompt=VENV build/mage_venv
virtualenv --prompt=VENV --no-site-packages --relocatable --always-copy build/mage_venv
# dirty hack - get fresh python version
#mv build/mage_venv/bin/python build/mage_venv/bin/python_old
#cp ~/mage_venv/bin/python build/mage_venv/bin/

source build/mage_venv/bin/activate || (echo "Cannot switch to venv. Command 'source' failed" && exit 1)

pip install --upgrade pip
pip install certifi
pip install tornado motor PyYaml
pip install mock logger
pip install pyrasite dowser cherrypy


deactivate

# Copy necessary libs
cp -rnL /usr/lib/python2.7/* build/mage_venv/lib/python2.7/

source build/mage_venv/bin/activate || (echo "Cannot switch to venv. Command 'source' failed" && exit 1)
cd server
cd tests/manual/
chmod +x test_recluster_equal.sh
./test_recluster_equal.sh mail || (echo "Recluster MAIL checks faled. Exiting" && exit 1)
./test_recluster_equal.sh disk || (echo "Recluster DISK checks faled. Exiting" && exit 1)
cd ../../
../build/mage_venv/bin/python2.7 run_tests.py || (echo "Tests was failed. Exiting" && deactivate && exit 1)
cd ..

deactivate

mkdir -p build/mage_venv/Mage
cp -r server build/mage_venv/Mage/

# mkdir -p build/mage_venv/usr/lib
#cp -rn /usr/lib/python2.7/* build/mage_venv/lib/python2.7/
#cp -rL /usr/lib/python2.7 build/mage_venv/usr/lib/

cd build
tar -hczf mage_venv.tgz mage_venv --exclude=*.pyc
