#!/usr/bin/env python
# Provides: yasmconf_check lucene_index_check

import urllib2
import json
import os
import time
from PIL import Image, ImageFont, ImageDraw
import sys

HOST_ANSWER_TIMEOUT = 31
URLLIB_ANSWER_TIMEOUT = 10
SLEEP = 2
TRIES = 2

OAUTH_TOKEN = "660ca916b9c1431195090f4ba7f52ed1"

BASE_URL = "https://nanny.yandex-team.ru/v2/services/"
#SERVICE_NAME = "mail_search_prod"
SERVICE_NAME = "mail_search_prestable"
#COMMAND_URL="/current_state/hosts/"
COMMAND_URL=""

TEMP_PREVDATA_FILE = '/tmp/lucene_check_prev.json'
TEMP_RELEASE_INFO = '/tmp/mail_lucene_stat_release.txt'
#JSON_OUTPUT = 'shards_lag.json'
DATA_PATH = 'data'

searchmap_manual=False
#searchmap_manual="http://cmsearch.yandex.ru/res/gencfg/stable-100-r36/generated/lucene/mail.cfg"

def make_auth_req(url, token=None):
    request = urllib2.Request(url)
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=20)
            break
        except Exception as e:
            attempts +=1
            print("Error reached {0} Retry count:{1} Url: {2}".format(e, attempts, url))
            time.sleep(SLEEP) 
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")            
    return result.read()

def make_auth_req2(url, token=None):
    request = urllib2.Request(url)
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=20)
            break
        except Exception as e:
            attempts +=1
            print("Error reached {0} Retry count:{1} Url: {2}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.readline()


def parse_json(data):
    return json.loads(data)


def get_searchmap_url(service_dict):
    for res in service_dict['runtime_attrs']['content']['resources']['url_files']:
        if res.get('local_path') == 'searchmap.txt':
            if searchmap_manual:
                return searchmap_manual
            return res['url']

def get_file_unparsed(filename):
    with open(filename, 'r') as f:
        return f.readlines()

def get_file_rbtorrent(link, downpath, cached):
    if not cached:
    # Get first download file in directory and ignore another
        cmd = "sky get -up -d".split(" ") + ["{0}".format(downpath)] + ["{0}".format(searchmap_url)]
        prc=subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        out,err = prc.communicate()
        print("Rbtorrent out:{0}, Error:{1}".format(err,out))
    for root, dirs, files in os.walk(downpath):
        for file_one in files:
            print file_one
            return get_file_unparsed("{0}/{1}".format(downpath,file_one))

def get_file_by_http(searchmap_url):
    return make_auth_req(searchmap_url).split("\n")

def get_searchmap_parsed(searchmap_url,release):
    """
    :param searchmap_url:string
    :return: list[dict[service][iNum][{host:port},{host2:port2}...],dict[service2][iNum2][{host:{port}, {host2:port2}..]]
    """
#    if os.path.isfile(TEMP_RELEASE_INFO):
#        release_old=get_file_unparsed(TEMP_RELEASE_INFO)
#        if not release_old == release:
#            if searchmap_url.startswith('rbtorrent:'):
#                searchmap_unparsed=get_file_rbtorrent(searchmap_url,"/tmp/mail_lucene_searchmap", cached=False)
#            else:
#                searchmap_unparsed=get_file_by_http(searchmap_url)
#
#            with open(TEMP_RELEASE_INFO, 'w+') as out:
#                out.write(release)
#                out.close()
#
#        else:
#            if searchmap_url.startswith('rbtorrent:'):
#                searchmap_unparsed=get_file_rbtorrent(searchmap_url,"/tmp/mail_lucene_searchmap", cached=True)
#    else:
#        with open(TEMP_RELEASE_INFO, 'w+') as out:
#            out.write(release)
#            out.close()
#        if searchmap_url.startswith('rbtorrent:'):
#            searchmap_unparsed=get_file_rbtorrent(searchmap_url,"/tmp/mail_lucene_searchmap")
#        else:
#            searchmap_unparsed=get_file_by_http(searchmap_url)        
#

    if searchmap_url.startswith('rbtorrent:'):
        searchmap_unparsed=get_file_rbtorrent(searchmap_url,"/tmp/mail_lucene_searchmap", cached=False)
    else:
        searchmap_unparsed=get_file_by_http(searchmap_url)

    return_dict = {}
    for line in searchmap_unparsed:
        if not line or not line.strip():
            continue
        if line.startswith("#"):
            continue
        # Get iNum
        services = line.split(" ")[0].split(",")
        for service in services:
            if not return_dict.get(service):
                return_dict[service]={}
#            print("line: {0}".format(line))
            iNum = line.split(" ")[1].split(",")[0]
            json_indexer_port = line.split(" ")[1].split(",")[5].split(":")[1]
            search_port = line.split(" ")[1].split(",")[6].split(":")[1]
            zk = line.split(",")[4].split("zk:")[1]
            shards = line.split(",")[3].split(":")[1]
            #tag = line.split(" ")[1].split(",")[1]
            #tagport = tag.split("_")[1]
            host = line.split(" ")[1].split(",")[2].split(":")[1]
            
            # create new key if it didnt exists
            if not return_dict[service].get(iNum):
                return_dict[service][iNum] = []
            return_dict[service][iNum].append({host: search_port,
                                              "host":host,
                                              "zk":zk, "hostname":"{0}:{1}".format(host,search_port), 
                                              "shards":shards})
    return return_dict

def get_searchmap_parsed_fromfile(searchmap_path):
    """
    :param searchmap_url:string
    :return: list[dict[service][iNum][{host:port},{host2:port2}...],dict[service2][iNum2][{host:{port}, {host2:port2}..]]
    """
    print searchmap_path

    with open(searchmap_path, 'r') as out:
        searchmap_unparsed = out.readlines()

    return_dict = {}
    for line in searchmap_unparsed:
        if not line or not line.strip():
            continue
        if line.startswith("#"):
            continue
        # Get iNum
        services = line.split(" ")[0].split(",")
        for service in services:
            if not return_dict.get(service):
                return_dict[service]={}
#            print("line: {0}".format(line))
            iNum = line.split(" ")[1].split(",")[0]
            json_indexer_port = line.split(" ")[1].split(",")[5].split(":")[1]
            search_port = line.split(" ")[1].split(",")[6].split(":")[1]
            zk = line.split(",")[4].split("zk:")[1]
            shards = line.split(",")[3].split(":")[1]
            #tag = line.split(" ")[1].split(",")[1]
            #tagport = tag.split("_")[1]
            host = line.split(" ")[1].split(",")[2].split(":")[1]
            
            # create new key if it didnt exists
            if not return_dict[service].get(iNum):
                return_dict[service][iNum] = []
            return_dict[service][iNum].append({host: search_port,
                                              "host":host,
                                              "zk":zk, "hostname":"{0}:{1}".format(host,search_port), 
                                              "shards":shards})
    return return_dict



def generate_uniq_hostlist(searchmap_parsed):
    uniq_hostlist = []
    for service, data in searchmap_parsed.iteritems():
        for iNum, hostlist in data.iteritems():
            for hostname in hostlist:
                if hostname not in uniq_hostlist:
                    uniq_hostlist.append(hostname)
    return uniq_hostlist

def get_json(filename):
    try:
        with open(filename, 'r') as f:
            return json.loads(f.readlines()[0])
    except IOError:
        return None


def get_uniq_zk_list(searchmap_parsed):
    zk_list=[]
    for service, data in searchmap_parsed.iteritems():

        for inum, hostlist in data.iteritems():
            for hostdata in hostlist:
                zk_list.append(hostdata['zk'])

    return set(zk_list)


def get_queuelen_dict(zk_uniq_urls):
    queuelen_d = {}

    for queue_desc in zk_uniq_urls:
        # sas1-5867.search.yandex.net:17973/17974|man1-6451.search.yandex.net:17973/17974|myt1-0441.search.yandex.net:17973/17974|man1-7014.search.yandex.net:17973/17974|sas1-8532.search.yandex.net:17973/17974|man1-7336.search.yandex.net:17973/17974|myt1-0693.search.yandex.net:17973/17974|sas1-7201.search.yandex.net:17973/17974|myt1-0541.search.yandex.net:17973/17974

        for zoolooser_head in queue_desc.split("|"):
            try:
                port = zoolooser_head.split("/")[1]
                host = zoolooser_head.split(":")[0]
                print "Queuelen request url: http://{0}:{1}/queuelen".format(host, port)
                url = "http://{0}:{1}/queuelen".format(host, port)
                req=make_auth_req(url, token=None)
            except Exception as e:
                print "Exception reached when trying to get queuelen from zookeeper {0} Try next head.".format(zoolooser_head)
                continue
            break

#        port = queue_desc.split("|")[2].split("/")[1]
#        host = queue_desc.split("|")[2].split(":")[0]
#        print "Queuelen request url: http://{0}:{1}/queuelen".format(host, port)
#        url = "http://{0}:{1}/queuelen".format(host, port)
#        req=make_auth_req(url, token=None)
        
        for queuelen_line in req.splitlines():
            service_name_q = queuelen_line.split("\t")[0]
            service_shard_q = queuelen_line.split("\t")[1]
            service_hostname_q = queuelen_line.split("\t")[2]
            service_queuelen_q = queuelen_line.split("\t")[3]
            service_positiontime_lag_q = queuelen_line.split("\t")[7]
    
            if not queuelen_d.get(service_name_q, False):
                queuelen_d[service_name_q]={}
            if not queuelen_d[service_name_q].get(service_shard_q):
                queuelen_d[service_name_q][service_shard_q]={}
    
            queuelen_d[service_name_q][service_shard_q][service_hostname_q] = [service_queuelen_q,service_positiontime_lag_q]
    return queuelen_d   

def redYellowGreen(value_raw):
    if value_raw == "False":
        return ((int(0), int(0), int(255)))

    value = int(value_raw)
    max = 1000
    if value > max:
        value = max
    if value < 0:
        value = 0

    green_max = 255
    red_max = 255
    red = 0
    green = 0
    blue = 0

    if value < max/2:
        green = green_max
        red = round((value/(max/2.0))*green_max)
    else:
        red = red_max
        green = round((1.0-((value-(max/2.0))/(max/2.0)))*red_max)
    return (int(red), int(green), int(blue))


if __name__ == "__main__":
#    url = BASE_URL+SERVICE_NAME+COMMAND_URL
#    print("Getting service {0} config by url {1}".format(SERVICE_NAME, url))
#    data = make_auth_req(url, OAUTH_TOKEN)
#    print("Done")
#    print("Parse service config.")
#    service_dict = parse_json(data)
#    release=service_dict['runtime_attrs']['content']['instances']['extended_gencfg_groups']['groups'][0]['release']
#    print("Done")
#    print("Get service {0} searchmap".format(SERVICE_NAME))
#    searchmap_url = get_searchmap_url(service_dict)
#    print ("Searchmap_url {0}".format(searchmap_url))
#    print("Done")
#    print("Parse service {0} searchmap".format(SERVICE_NAME))
#
#    searchmap_parsed = get_searchmap_parsed(searchmap_url,release)
    searchmap_parsed = get_searchmap_parsed_fromfile("mail.cfg")
    #print searchmap_parsed
    print("Done")

    zk_uniq_urls = get_uniq_zk_list(searchmap_parsed)
    #service:inum:host:[queue,ms]
    queuelen_dict = get_queuelen_dict(zk_uniq_urls)
    print("Getting queuelen is done. Filter hosts now.")
    
    #change_log:{
    #  "38346": {
    #    "myt1-1338.search.yandex.net": [
    #      "471661",
    #      "6318012225"
    #    ],
    #    "disk-nginx.search.yandex.net": [
    #      "471769",
    #      "6318812324"
    #    ],
    #    "iex-proxy-prod3.n.yandex-team.ru": [
    #      "0",
    #      "6729"
    #    ],
    
    with open("{0}/searchmap_parsed.json".format(DATA_PATH), 'w+') as out:
        out.write(json.dumps(searchmap_parsed))
        out.close()
    
    actual_hosts = {}
    for service, data in searchmap_parsed.iteritems():
        actual_hosts[service] = {}
        for inum, hostlist in data.iteritems():
    #{'iNum:154': [{'sas1-8882.search.yandex.net': '18066', 'zk':'smt', 'shards':'12444-12890'}, 
            for hostdata in hostlist:
                shard_list = hostdata["shards"].split("-")
                for shard_num in range(int(shard_list[0]), int(shard_list[1])+1):
                    if not actual_hosts[service].get(str(shard_num), False):
                        actual_hosts[service][str(shard_num)] = []
                    actual_hosts[service][str(shard_num)].append([queuelen_dict[service][str(shard_num)].get(hostdata['host'],["False","False"])[0],
                                                                  queuelen_dict[service][str(shard_num)].get(hostdata['host'],["False","False"])[1],
                                                                  hostdata['hostname'],
                                                                  inum.split(":")[1]])
    #                actual_hosts[service][str(shard_num)].append(queuelen_dict[service][str(shard_num)].get(hostdata['host'],[False,False]))
    #                actual_hosts[service][str(shard_num)].append(hostdata['hostname'])
    
    
    side = 4
    width_back = 3200
    height_back = 1400
    
    coords_dict={}
    for service,data in actual_hosts.iteritems():
        coords_dict[service]={}
    
        #Move previous image to timestamp
        try:
            os.rename("{0}/{1}.json".format(DATA_PATH,service), "{0}/{1}.json_{2}".format(DATA_PATH,service,int(time.time())))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))
    
        with open("{0}/{1}.json".format(DATA_PATH,service), 'w+') as out:
            out.write(json.dumps(data))
            out.close()
    
        shard=0
        im = Image.new('RGB', (width_back,height_back), (255,255,255))
        dr = ImageDraw.Draw(im)
    
        for h in xrange(0,width_back,side*2):
            for w in xrange(0,height_back,side*2):
                if shard > 65533:
                    break
                curr_shard = data["{0}".format(shard)]
                replica_n =0
                for r_h in xrange(0,side*2,side):
                    for r_w in xrange(0,side*2,side):
                        
                        dr.rectangle(((r_h+h,r_w+w),(r_h+h+side,r_w+w+side)), fill=redYellowGreen(curr_shard[replica_n][0]), outline = "white")
                        coords_dict[service]["{0}_{1}".format((r_h+h)/side,(r_w+w)/side)]=[shard, replica_n, curr_shard[replica_n][0], curr_shard[replica_n][2], curr_shard[replica_n][3]]
                        replica_n+=1
                shard+=1
        #Move previous image to timestamp
        try:
            os.rename("{0}/{1}.png".format(DATA_PATH,service), "{0}/{1}.png_{2}".format(DATA_PATH,service,int(time.time())))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))
        im.save("{0}/{1}.png".format(DATA_PATH,service))
    
        try:
            os.rename("{0}/{1}_{2}".format(DATA_PATH,service,"coords.json"), "{0}/{1}_{2}_{3}".format(DATA_PATH,service,"coords.json",int(time.time())))
        except Exception as e:
            print("Cannot move old file - first launch?:{0}".format(e))
        with open("{0}/{1}_{2}".format(DATA_PATH,service,"coords.json"), 'w+') as out:
            out.write(json.dumps(coords_dict[service]))
            out.close()
