import sys

print(sys.argv)

offset = int(sys.argv[1])
shard_count = int(sys.argv[2])
meta_shard_count = int(sys.argv[3])

queue_service_cfg = str(sys.argv[4])
# meta_shard_id = int(sys.argv[4])

split_queue_service_config = {"mail": [[[0, 16383], "mail_search_queue_prod1"],
                                       [[16384, 32767], "mail_search_queue_prod2"],
                                       [[32768, 49151], "mail_search_queue_prod3_new"],
                                       [[49152, 65533], "mail_search_queue_prod4"]],
                              "mailoffline": [[[0, 65533], "ps_queue"]]
                              }


fmt = "%(service)s iNum:%(iNum)s,tag:%(tag_mtn)s,host:%(mtn_backbone_hostname)s,shards:%(shards)s,\
      zk:%(zk_mtn)s,json_indexer_port:%(json_indexer_port)s,search_port_ng:%(search_port_ng)s,search_port:%(search_port)s,dump_port:%(dump_port)s"


def get_ranges_intersection(r1, r2):
    """
        Get intersection of couple of segments
        :param r1: (tuple) first segment in form [begin, end]
        :param r2: (tuple) second segment in form [begin, end]
        :return: None if no intersection, tuple in form [begin, end] otherwise
    """

    f1, l1 = r1
    f2, l2 = r2

    f_result = max(f1, f2)
    l_result = min(l1, l2)

    if l_result < f_result:
        return None

    return f_result, l_result

def get_lucene_shard_range(shard_count, shard_id, total_shards):
    first_lucene_shard = shard_id * shard_count / total_shards
    last_lucene_shard = (shard_id + 1) * shard_count / total_shards - 1

    return first_lucene_shard, last_lucene_shard

result = []

for meta_shard_id in range(0,meta_shard_count):
    lucene_first_shard, lucene_last_shard = get_lucene_shard_range(shard_count,
                                                                   meta_shard_id,
                                                                   meta_shard_count)

    lucene_first_shard = (lucene_first_shard + offset) % shard_count
    lucene_last_shard = (lucene_last_shard + offset) % shard_count
    lucene_shard_ranges = []

    if lucene_first_shard > lucene_last_shard:
        lucene_shard_ranges.append((lucene_first_shard, shard_count - 1))
        lucene_shard_ranges.append((0, lucene_last_shard))
    else:
        lucene_shard_ranges.append((lucene_first_shard, lucene_last_shard))

    data = {}

    for lucene_first_shard, lucene_last_shard in lucene_shard_ranges:
        for lucene_split_range, lucene_queue_line in split_queue_service_config[queue_service_cfg]:
            r = get_ranges_intersection(lucene_split_range, (lucene_first_shard, lucene_last_shard))
            if r is not None:
                data["shards"] = "%s-%s" % (int(r[0]), int(r[1]))
                data["zk"] = lucene_queue_line
                data["iNum"] = meta_shard_id
                # # Save zk and zk_mtn line
                # data["zk_mtn"] = zoo_split_uncovered['zk_mtn'][lucene_split_range]
                # data["_id"] = ObjectId()
                result.append(data.copy())

for rng in result:
    print(f"corp_change_log iNum:{rng['iNum']},tag:mailcorp-search-yp-prod-{rng['iNum']+1}.sas,host:mailcorp-search-yp-prod-{rng['iNum']+1}.sas.yp-c.yandex.net,shards:{rng['shards']},zk:{rng['zk']},json_indexer_port:84,search_port_ng:81,search_port:80,dump_port:86")
#    print(f"service_name iNum:{rng['iNum']}, shards:{rng['shards']}, zk:{rng['zk']}")

