#!/usr/bin/env python
# -*- coding: utf-8 -*-
# author: okkk

# Script exiting with "1" error code if cannot get searchmap from cluster management system

import json
import os
import urllib2
import time
import sys

CLUSTER_URL = "http://mage.n.yandex-team.ru/api/v1.0/mail/getmap?revision=recluster_searchmap:latest&tag={BSCONFIG_IHOST}_{BSCONFIG_IPORT}".format(**os.environ)

TRIES = 2
SLEEP = 5
OAUTH_TOKEN = ""
SEARCHMAP_PATH = "searchmap.txt"

def make_auth_req_post(url, token=None):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=20)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


def get_json(filename):
    try:
        with open(filename, 'r') as f:
            return json.loads("".join(f.readlines()))
    except IOError:
        return None


if __name__ == "__main__":
    try:
        #Getting map
        answer = make_auth_req_post(CLUSTER_URL, token=OAUTH_TOKEN)

        with open(SEARCHMAP_PATH, 'w+') as f:
            f.write(answer)

    except Exception as e:
        print "Cannot get latest searchmap version. Executing exception reached: {0}, exit normally".format(e)
        sys.exit(0)