#!/usr/bin/env python
# -*- coding: utf-8 -*-
# author: okkk

# Script exiting with "1" error code if cannot get searchmap from cluster management system

import os
import urllib2
import time
import sys

CLUSTER_URL = "http://mage.n.yandex-team.ru/api/v1.0/mail/getmap?revision=recluster_searchmap:{REVISION}&tag={BSCONFIG_IHOST}_{BSCONFIG_IPORT}"

TRIES = 2
SLEEP = 5
OAUTH_TOKEN = ""
SEARCHMAP_PATH = "searchmap.txt"
REVISION_FILE_PATH = "revision.txt"
LJINX_HOOK_URL = "http://localhost:{LJINX_PORT}/reloadsearchmap?notifyhook"
LJINX_OFFSET = 5


def make_auth_req_post(url, token=None, timeout=20):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=timeout)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


if __name__ == "__main__":
    try:
        env = os.environ

        with open(REVISION_FILE_PATH, 'r') as f:
            revision = f.readlines()[0].strip()

        print("Revision change reached through notify hook: {0}".format(revision))

        mage_url = CLUSTER_URL.format(BSCONFIG_IHOST=env['BSCONFIG_IHOST'],
                                      BSCONFIG_IPORT=env['BSCONFIG_IPORT'],
                                      REVISION=revision)
        reloadmap_url = LJINX_HOOK_URL.format(LJINX_PORT=int(env['BSCONFIG_IPORT']) + LJINX_OFFSET)

        print("Getting map through url: {0}".format(mage_url))
        print("Ljinx reload url: {0}".format(reloadmap_url))

        # Getting map
        answer_map = make_auth_req_post(mage_url, token=OAUTH_TOKEN, timeout=20)
        with open(SEARCHMAP_PATH, 'w+') as f:
            f.write(answer_map)

        # Reload map in ljinx
        answer_hook = make_auth_req_post(reloadmap_url, token=OAUTH_TOKEN, timeout=60)

        print("Ljinx hook answer:{0}".format(answer_hook))
    except Exception as e:
        print("Cannot get latest searchmap version. Executing exception reached: {0}, exiting with error".format(e))
        sys.exit(1)
