import tornado.web
import tornado.gen
import logging

from BaseHandler import BaseHandler

# TODO: make common handler - unite getmap handler for mail and disk getmap handlers
class GetmapHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(GetmapHandler, self).__init__(application, request, **kwargs)
        self.log = logging.getLogger("tornado.application")

        self.full = self.get_argument("full", False, True)
        self.revision = self.get_argument("revision", False, True)
        self.tag = self.get_argument("tag", False, True)
        self.getfat = self.get_argument("getfat", False)
        self.pformat = self.get_argument("pformat", False)
        if self.pformat == "zkmtn":
            # Turn off pformat for zkmtn param by default
            self.pformat = False

        # TODO: Fast fix. dont send map with fat inums by default, send it for ^searchmap_split revs only
        if self.generator.ISFAT:
            if self.revision.startswith(self.generator.RECLUSTER_SEARCHMAP_SPLIT_PREFIX)\
                    or self.revision.startswith(self.generator.SEARCHMAP_SPLIT_PREFIX):
                self.getfat = True

        if self.getfat:
            self.type = self.generator.FATMAPTYPE
        else:
            self.type = self.generator.MAPTYPE

    def initialize(self, generator):
        self.generator = generator
        self.log = generator.log
        #self.log.info("Trying to get map for project: {0}".format(generator.PROJECT))

    @tornado.gen.coroutine
    def get(self):

        if self.full and self.revision and self.getfat:
            wholemap = yield self.find_hosts(self.revision,
                                             {"project": self.generator.PROJECT},
                                             limit=60000)
        elif self.full and self.revision:
            wholemap = yield self.find_hosts(self.revision,
                                             {"project": self.generator.PROJECT,
                                              "type": self.generator.MAPTYPE},
                                             limit=60000)
        elif self.tag and self.revision:
            wholemap = yield self.find_hosts(self.revision,
                                             {"project": self.generator.PROJECT,
                                              "tag": self.tag},
                                             limit=100)
        else:
            self._on_response("", "Searchmap not found for such params")

        self._on_response_write_map(wholemap, False)
