import tornado.web
import tornado.gen
import logging

import json
from BaseHandler import BaseHandler


class LastrevHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(LastrevHandler, self).__init__(application, request, **kwargs)
        self.log = logging.getLogger('Mage')
        self.status = self.get_argument("status", False, True)
        self.revision = self.get_argument("revision", False, True)
        self.writeonly = self.get_argument("writeonly", False, True)

    def initialize(self, generator):
        self.generator = generator
        self.log = generator.log

    @tornado.gen.coroutine
    def get(self):
        if not self.status and not self.revision:
            lastrev_meta = yield self.find_hosts(self.generator.last_revison,
                                                 {"project": self.generator.PROJECT},
                                                 limit=1000)
            logging.info("Last revision is: {0}".format(lastrev_meta))
            lastrev_meta[0].pop('_id', None)
            self.write(json.dumps({'status': 'success',
                                   'data': lastrev_meta[0],
                                   'message': ''}))
        elif self.status and self.revision:
            # get lastrev
            lastrev_meta = yield self.find_hosts(self.generator.last_revison,
                                                 {"project": self.generator.PROJECT},
                                                 limit=1000)
            pre_lastrev_rev = lastrev_meta[0]['revision']
            query = [{'revision': self.revision,
                      'pre_revision': pre_lastrev_rev,
                      'status': self.status,
                      "project": self.generator.PROJECT}]
            logging.info("Update last revision to: {0} ".format(json.dumps(query)))
            bulk_stat = yield self.bulk_truncate_hosts(self.generator.last_revison,
                                                       {"project": self.generator.PROJECT},
                                                       query)
            logging.info("Update rev complete: {0}".format(json.dumps(bulk_stat)))
            self.write(json.dumps({'status': 'success',
                                   'data': '',
                                   'message': bulk_stat}))
        # For testing purposes
        elif self.writeonly and self.status and self.revision:
            query = [{'revision': self.revision,
                      'pre_revision': "false",
                      'status': self.status,
                      "project": self.generator.PROJECT}]
            logging.info("Update last revision to: {0} ".format(json.dumps(query)))
            bulk_stat = yield self.bulk_truncate_hosts(self.generator.last_revison,
                                                       {"project": self.generator.PROJECT},
                                                       query)
            logging.info("Update rev complete: {0}".format(json.dumps(bulk_stat)))
            self.write(json.dumps({'status': 'success',
                                   'data': '',
                                   'message': bulk_stat}))
        else:
            logging.info("Arguments error")
            self.write(json.dumps({'status': 'error',
                                   'data': '',
                                   'message': 'Arguments error'}))

        self.finish()