import tornado.web
import tornado.gen
import tornado
import logging

from libs.context.base import Base
from BaseHandler import BaseHandler

#sys.setrecursionlimit(19000)


class SyncHostsHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(SyncHostsHandler, self).__init__(application, request, **kwargs)
        self.log = logging.getLogger("tornado.application")

    def initialize(self, generator):
        self.generator = generator
        self.log = generator.log

    @tornado.gen.coroutine
    def get(self):
        revision = self.get_argument("revision", False, True)
        project = self.get_argument("project", False, True)
        nservices = self.get_argument("nservices", False, True).split(",")

        if not revision or not nservices or not project:
            self._on_response("", "You must specify revision, project and nanny services for example: "
                                  "revision=tags/stable-101-r80&nservices=mail_search_prod,mail_search_prestable&project=mail")

        gencfg_service_names = Base.get_gencfg_groups(nservices,
                                                      timeout=600,
                                                      oauth_token=self.settings["oauth_token"])

        if self.generator.ISFAT:
            fat_groups = self.generator.FAT_GROUPS
        else:
            fat_groups = {}

        hosts_list = Base.get_gencfg_instances(gencfg_service_names,
                                               revision,
                                               timeout=600,
                                               fat_groups=fat_groups)

        rich_hosts_list = SyncHostsHandler.enrich_hosts_list(hosts_list, project)

        update_result = yield self.bulk_truncate_hosts(revision,
                                                       {"project": project},
                                                       rich_hosts_list
                                                       )

        self.log.info("Revision:{0} update status is: {1} ".format(revision,
                                                                   update_result
                                                                   ))
        self._on_response("\nSuccess. Rev:{0} for groups: {1} was synced from GENCFG. Update status is: {2}".format(revision,
                                                                                                                    gencfg_service_names,
                                                                                                                    update_result),False)

    @staticmethod
    def enrich_hosts_list(hosts_list, project):
        for host in hosts_list:
            host['tag'] = "{0}_{1}".format(host['hostname'].split(".")[0],
                                           host['port'])

            # We need tag_mtn for Syncmap action - to renew old searchmap.
            if host["mtn_backbone_hostname"] != "False":
                host['tag_mtn'] = host["mtn_backbone_hostname"].split(".")[0]
            else:
                host['tag_mtn'] = "False"
            host['project'] = project
        return hosts_list