import tornado.web
import tornado.gen

from libs.exceptions import *
from BaseHandler import BaseHandler


class SyncmapHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(SyncmapHandler, self).__init__(application, request, **kwargs)

    def initialize(self, generator):
        self.generator = generator
        self.log = generator.log

    @tornado.gen.coroutine
    def get(self):
        self.revision = self.get_argument("revision", False, True)
        self.project = self.generator.PROJECT

        self.mprefixes = self.generator.SEARCHMAP_PREFIX

        upd_collections = []
        for mprefix in self.mprefixes:
            upd_collections.append("{0}:{1}".format(mprefix, self.revision))

        self.log.info("Collections to sync: {0}".format(upd_collections))

        synchosts_data = yield self.find_hosts(self.revision,
                                               {"project": self.project},
                                               limit=60000)
        if not synchosts_data:
            raise MageAPIServerHardError("Cannot find hosts from specified revision! Sync hosts first. Revision: {0}"
                                         .format(self.revision))

        for collection in upd_collections:
            for hst in synchosts_data:
                upd_result = yield self.update_hosts(collection,
                                                     {
                                                         "project": self.project,
                                                         "tag": hst["tag"]
                                                     },
                                                     {
                                                         "$set": {
                                                             "dc": hst["dc"],
                                                             "hostname":  hst["hostname"]
                                                         }
                                                      })
                if upd_result.modified_count != 0:
                    self.log.info("Update tag: {0} Updates count: {1}".format(hst["tag"], upd_result.modified_count))

            # Simple check
            chk_dc = yield self.find_hosts(collection,
                                                     {"project": self.project,
                                                      "dc": {"$exists": False}},
                                                     limit=60000)
            if chk_dc:
                self.log.info("ERROR! mtn_backbone_hostname doesnt exist for some searchmap hosts. Resync please.")
                raise MageAPIServerHardError("Mtn_backbone_hostname doesnt exist for some searchmap hosts. "
                                             "Resync needed.")

            self.log.info("Hosts in map without dc: {0}".format(chk_dc))

        self._on_response("\nSuccess. Syncmap is completed", False)
