import tornado.web
import tornado.gen
import logging

from BaseHandler import BaseHandler

# TODO: make common handler - unite getmap handler for mail and disk getmap handlers
class UploadHandler(BaseHandler):
    def __init__(self, application, request, **kwargs):
        super(UploadHandler, self).__init__(application, request, **kwargs)
        self.revision = self.get_argument("revision")

    def initialize(self, generator):
        self.generator = generator
        self.log = generator.log

    def data_received(self, chunk):
        pass

    @tornado.gen.coroutine
    def post(self):
        fileinfo = self.request.files['searchmap'][0]
        recluster = self.get_argument("recluster", default=False)

        if recluster:
            s_revision = "{0}:{1}".format("searchmap_recluster", self.get_argument("revision"))
        else:
            s_revision = "{0}:{1}".format("searchmap", self.get_argument("revision"))

        searchmap = fileinfo['body']

        parsed_searchmap = self.parse_searchmap(self.generator.PROJECT, searchmap)

        # we need find fat and thin hosts here for use it information for patch searchmap
        curr_hostlist = yield self.find_hosts(self.revision,
                                              {"project": self.generator.PROJECT},
                                              limit=60000)

        # searchmap with gencfg group - ready for writting to database
        patched_searchmap = self._patch_searchmap(parsed_searchmap, curr_hostlist)

        update_result = yield self.bulk_truncate_hosts(s_revision,
                                                       {"project": self.generator.PROJECT},
                                                       patched_searchmap
                                                       )

        self.log.info("Revision:{0} update status is: {1}"
                      .format(s_revision, update_result))
        self.write("\nSearchmap update stats: {0}".format(update_result))

        #print patched_searchmap[0]

        self._on_response("\nSuccess. Recluster was finished", False)


    @tornado.gen.coroutine
    def find_hosts(self, collection, query, limit):
        settings = self.settings["db"]
        result = yield settings.find_cursor(collection, query).to_list(length=limit)
        raise tornado.gen.Return(result)


    @tornado.gen.coroutine
    def bulk_truncate_hosts(self, collection, query, update):
        settings = self.settings["db"]
        result = yield settings.bulk_truncate_cursor(collection, query, update)
        stats = {'deleted_count': result.deleted_count,
                 'inserted_count': result.inserted_count,
                 'matched_count': result.matched_count,
                 'modified_count': result.modified_count,
                 'upserted_count': result.upserted_count
                 }
        raise tornado.gen.Return(stats)


    @staticmethod
    def _patch_searchmap(parsed_searchmap, curr_hostlist):

        def make_locdict(hostlist):
            return_dict = {}
            for instance in hostlist:
                curr_tag = "{0}_{1}".format(instance['hostname'].partition(".")[0], instance['port'])
                return_dict[curr_tag] = {}
                return_dict[curr_tag]['group'] = instance['group']
                return_dict[curr_tag]['dc'] = instance['dc']
                return_dict[curr_tag]['type'] = instance['type']

                if instance["mtn_backbone_hostname"] != "False":
                    return_dict[curr_tag]['tag_mtn'] = instance["mtn_backbone_hostname"].split(".")[0]
                    return_dict[curr_tag]['mtn_backbone_hostname'] = instance["mtn_backbone_hostname"]
                else:
                    return_dict[curr_tag]['tag_mtn'] = "False"
                    return_dict[curr_tag]['mtn_backbone_hostname'] = "False"
            return return_dict

        locdict = make_locdict(curr_hostlist)

        for mapinstance in parsed_searchmap:
            # get mtn tag and group from synced isntances
            curr_map_tag = "{0}_{1}".format(mapinstance["host"].partition(".")[0], mapinstance["port"])
            mapinstance["group"] = locdict[curr_map_tag]["group"]
            mapinstance["tag_mtn"] = locdict[curr_map_tag]["tag_mtn"]
            mapinstance["mtn_backbone_hostname"] = locdict[curr_map_tag]["mtn_backbone_hostname"]
            mapinstance["hostname"] = mapinstance.pop("host")
            mapinstance["dc"] = locdict[curr_map_tag]["dc"]
            mapinstance["type"] = locdict[curr_map_tag]["type"]

        return parsed_searchmap


    @staticmethod
    def parse_searchmap(project, searchmap):
        """
        Parse uploaded file and return list of dicts.

        :param inst_type: thin or fat
        :param project: mail, disk or smth
        :param searchmap: uploaded text
        """

        searchmap_l = []

        for line in searchmap.split('\n'):
            if not line:
                continue
            if line.startswith("#"):
                continue

            service = line.split()[0]
            data = {s_element.split(':')[0]: "{0}".format(s_element.split(':')[1]) if s_element.split(':')[0] != "zk"
                    else s_element.split('zk:')[1] for s_element in line.split()[1].split(',')}
            data["project"] = project
            if int(data["iNum"]) in [100500]:
                data["type"] = "fat"
            else:
                data["type"] = "thin"
            data["service"] = service
            data["port"] = data["tag"].split("_")[1]
            searchmap_l.append(data)

        return searchmap_l

    def _on_response(self, result, error, code=501):
        if error:
            if isinstance(error, str):
                raise tornado.web.HTTPError(code, error)
            else:
                raise tornado.web.HTTPError(code, str(error.details))
        else:
            self.write(str(result))
        self.finish()