#import motor.motor_tornado
#from pymongo.read_preferences import ReadPreference
from pymongo import InsertOne, DeleteMany, ReplaceOne, UpdateOne
from pymongo import WriteConcern
#import pymongo
import logging


class MongoDb:

    def __init__(self, db):
        self.log = logging.getLogger("tornado.application")
        self.log.info("Init mongodb")
        self.db = db

    def find_cursor(self, collection, query):
        return self.db[collection].find(query).sort('_id')

    def find_one_and_replace_cursor(self, collection, query, update):
        return self.db[collection].find_one_and_replace(query,
                                                        update,
                                                        upsert=True)

    def update_many_cursor(self, collection, query, update):
        return self.db[collection].update_many(query,
                                               update,
                                               upsert=True)

    def bulk_truncate_cursor(self, collection_drop, query, update_data):
        oper_list=[]
        oper_list.append(DeleteMany(query))
        for elem in update_data:
            oper_list.append(InsertOne(elem))
        return self.db.get_collection(collection_drop, write_concern=WriteConcern(w=2, wtimeout=30000)).bulk_write(oper_list)

        #bulk = self.db[collection_drop].initialize_ordered_bulk_op()
        #bulk.find(query).remove()
        #for elem in update_data:
        #        bulk.insert(elem)
        #return bulk.execute({'w': 2, 'wtimeout': 30000})

    def find(self, collection, query, callback=False, limit=1000):
        self.db[collection].find(query).to_list(length=limit,
                                                callback=callback)

    def insert_one(self, collection, data, callback):
        self.db[collection].insert_one(data, callback=callback)

    def insert_many(self, collection, data, callback):
        self.db[collection].insert_many(data, callback=callback)

    def update_many(self, collection, query, update, callback):
        self.db[collection].update_many(query,
                                        update,
                                        upsert=True,
                                        callback=callback)

    def drop(self, collection, callback):
        self.db[collection].drop(callback=callback)

    def delete_many(self, collection, query, callback):
        self.db[collection].delete_many(query, callback=callback)

    def find_one_and_replace(self, collection, query, update, callback):
        #print query
        self.db[collection].find_one_and_replace(query,
                                                 update,
                                                 upsert=True,
                                                 callback=callback)

    def bulk_truncate(self, collection_drop, update_data, callback, query={}):
        bulk = self.db[collection_drop].initialize_ordered_bulk_op()
        bulk.find(query).remove()
        for elem in update_data:
                bulk.insert(elem)
        bulk.execute({'w': 2, 'wtimeout': 30000}, callback=callback)

#TODO: create index after write to db, for keys
#    def create_index(self, collection, callback, keys=[]):
#        self.db.[collection].createIndex(keys, callback=callback)


