import logging
#import traceback
import base
from ..exceptions import *


class Generator(base.Base):
    def __init__(self, config):
        super(Generator, self).__init__()

        self.last_revison = "last_revison"
        self.pre_last_revison = "pre_last_revison"

        self.log = logging.getLogger("tornado.application")
        self.PROJECT = config['COMMON']['project']
        self.MAPTYPE = config['COMMON']['mapType']

        logging.info("{service} config initialization".format(service=self.PROJECT))

        self.MINMAPSIZE = config['COMMON']['minMapsize']
        self.SHARD_COUNT = config['COMMON']['shardCount']
        self.NANNY_GROUPS = config['COMMON']['nannyGroups']
        self.INUM_START = config['REPLICA']['inum']['start']
        self.INUM_END = config['REPLICA']['inum']['end']
        self.INUM_TOTAL = config['REPLICA']['inum']['total']

        self.SEARCHMAP_PREFIX = config["SEARCHMAP"]["searchmapPrefix"]
        self.RECLUSTER_SEARCHMAP_PREFIX = config["SEARCHMAP"]["reclusterSearchmapPrefix"]

        # Possibly index out of range here if service doesnt contains G@
        try:
            self.GROUPS = {k.split("G@")[1]: v for k, v in config['REPLICA']['groups'].items()}
        except Exception as e:
            logging.error("Cannot parse group names: {0}.".format(e))

        self.SHARD_SPLIT = config['SEARCHMAP']['shardSplit']
        for split in self.SHARD_SPLIT:
            if not isinstance(split[0], list):
                self.log.error("Current split is: {0}".format(split))
                raise MageAPIServerHardError("Cannot parse SHARD_SPLIT param. First value must be a list")

        self.SHARD_SPLIT_OFFLINE = config['SEARCHMAP']['shardSplitOffline']
        for split in self.SHARD_SPLIT_OFFLINE:
            if not isinstance(split[0], list):
                self.log.error("Current split is: {0}".format(split))
                raise MageAPIServerHardError("Cannot parse SHARD_SPLIT_OFFLINE param. First value must be a list")

        self.SERVICES_GENSETTINGS = config['SEARCHMAP']['queueSetup']
        self.FMT = config['FORMAT']['searchMapFormat']
        self.MTN_HOSTNAMES_FIX = str(config['SEARCHMAP'].get('mtnNamesFix', False))
        self.REPLICAFACTOR = sum(self.GROUPS.values())

        self.ISFAT = False
        self.FAT_GROUPS = {}

        #FAT

        if config.get('FAT', False):
            self.ISFAT = True
            self.log.info("{project}: Fat configuration is specified. Trying to parse it.".format(project=self.PROJECT))
            try:
                self.FAT_GROUPS = {k.split("G@")[1]: v for k, v in config['FAT']['fatGroups'].items()}
            except Exception as e:
                logging.error("Cannot parse group names: {0}.".format(e))
            self.FAT_SHARDLIST = map(lambda x: int(x) % self.SHARD_COUNT,
                                     config['FAT']['fatUidList'])
            self.INUMFAT = str(config['FAT']['inumFat'])
            self.FATMAPTYPE = config['FAT']['mapType']
            self.FATREPLICAFACTOR = sum(self.FAT_GROUPS.values())

            self.SEARCHMAP_SPLIT_PREFIX = config["FAT"]["searchmapSplitPrefix"]
            self.RECLUSTER_SEARCHMAP_SPLIT_PREFIX = config["FAT"]["reclusterSearchmapSplitPrefix"]
        else:
            self.log.info("{project}: fat configuration is not specified".format(project=self.PROJECT))


    def gen_maps(self, current_revision_list, prev_revision_list, oauth_token=False):
        current_recluster_searchmap_dict, current_searchmap_dict = self.make_recluster_dict(
            current_revision_list,
            prev_revision_list,
            self.REPLICAFACTOR,
            self.log)
        current_result_searchmap = self.gen_wholemap(current_searchmap_dict,
                                                     self.PROJECT,
                                                     oauth_token)
        current_result_recluster_searchmap = self.gen_wholemap(current_recluster_searchmap_dict,
                                                               self.PROJECT,
                                                               oauth_token)
        self.log.info("Len curr:{0}".format(len(current_result_searchmap)))
        self.log.info("Len recluster curr:{0}".format(len(current_result_recluster_searchmap)))
        return current_result_searchmap, current_result_recluster_searchmap

    def gen_singlemap(self, instances_list, oauth_token=False):
        searchmap_dict = self.make_location_set(instances_list)
        searchmap = self.gen_wholemap(self.generate_byshard_instances(searchmap_dict,
                                                                      range(self.INUM_START, self.INUM_END),
                                                                      self.GROUPS),
                                      self.PROJECT,
                                      oauth_token,
                                      from_scratch=True)
        return searchmap

    def gen_fat_maps(self, current_revision_list, prev_searchmap, oauth_token=False):
        current_recluster_searchmap_dict, current_searchmap_dict = self.make_recluster_dict(
            current_revision_list,
            prev_searchmap,
            self.FATREPLICAFACTOR,
            self.log,
            fat=True)

        current_result_searchmap = self.gen_fat_wholemap(current_searchmap_dict,
                                                         oauth_token,
                                                         from_scratch=False)

        current_result_recluster_searchmap = self.gen_fat_wholemap(current_recluster_searchmap_dict,
                                                                   oauth_token,
                                                                   from_scratch=False)

        return current_result_searchmap, current_result_recluster_searchmap

    def gen_fat_singlemap(self, instances_list, oauth_token=False):
        # create instances set by location
        location_set = self.make_location_set(instances_list)

        # insert in any shard list of hosts based by repilicafactor
        byshard_instances = self.generate_byshard_instances(location_set,
                                                            self.FAT_SHARDLIST,
                                                            self.FAT_GROUPS,
                                                            fat=True)
        #print byshard_instances

        searchmap = self.gen_fat_wholemap(byshard_instances,
                                          oauth_token,
                                          from_scratch=True)
        return searchmap
