# -*- coding: utf-8 -*-

class MageAPIError(Exception):
    pass

class MageAPIResultError(Exception):
    def __init__(self, code, message, *args):
        super(MageAPIResultError, self).__init__(message.format(*args) if args else message)
        self.code = code

class MageAPIClientError(MageAPIError):
    pass

class MageAPIServerError(MageAPIError):
    pass

class MageAPIServerSoftError(MageAPIServerError):
    pass

class MageAPIServerHardError(MageAPIServerError):
    pass

class MageAPIWireError(MageAPIClientError):
    pass

class MageAPIConnectError(MageAPIWireError):
    pass

class MageAPIEncodeError(MageAPIClientError):
    pass

class MageAPIDecodeError(MageAPIClientError):
    pass