#!/usr/bin/env python
# -*- coding: utf-8 -*-
# author: okkk

# Script  exiting with "1" error code if cannot get searchmap from cluster management system

import os
import urllib2
import time
import sys
import json

MAGE_URL = "http://mage.n.yandex-team.ru/api/v1.0/"
CLUSTER_URL = "{MAGE_URL}mail/getmap?revision={REVISION}&full=true"
LASTREV_URL = "{MAGE_URL}mail/lastrev".format(MAGE_URL=MAGE_URL)

RELOADMAP_HOOKS = [{"url": "http://localhost:{PORT}/reloadsearchmap?notifyhook", "port_offset": "5"}]

TRIES = 2
SLEEP = 5
OAUTH_TOKEN = ""
SEARCHMAP_PATH = "searchmap_mail.txt"
REVISION_FILE_PATH = "revision_mail.txt"


def make_auth_req_post(url, token=None, timeout=20):
    request = urllib2.Request(url)
    request.add_header('Content-Type', 'application/json')
    if token:
        request.add_header("Authorization", "OAuth {0}".format(token))
    attempts = 0
    while attempts < TRIES:
        try:
            result = urllib2.urlopen(request, timeout=timeout)
            break
        except Exception as e:
            attempts += 1
            print("Error reached {0} Url: {2} Retry count:{1}".format(e, attempts, url))
            time.sleep(SLEEP)
            if attempts == TRIES:
                print("Timeout!")
                raise Exception("Timeout exception!")
    return result.read()


def get_mage_last_revision(self, lastrev_mage_url, timeout=20):
    data = self.make_auth_req("{0}mail/lastrev".format(lastrev_mage_url), timeout=timeout)
    dataj = json.loads(data)

    if dataj['status'] != 'success':
        return False
    return dataj['data']


if __name__ == "__main__":
    try:
        env = os.environ

        # If instance starts first time and recluster is in progress - instance cannot start due recluster status != recluster_checked
        # 0. Get last revision and build reviosn line.
        mage_last_rev_status = get_mage_last_revision(LASTREV_URL)
        if not mage_last_rev_status:
            print("Cannot get latest searchmap version. Mage_last_rev_status returns: {0}"
                  .format(mage_last_rev_status))
            sys.exit(1)

        # build revision line lastrev to file - recluster_searchmap if status "recluster_checked", simple searchmap if "finished"
        if mage_last_rev_status["status"] == "recluster_checked":
            revision_prefix = "recluster_"
        elif mage_last_rev_status["status"] == "finished":
            revision_prefix = ""
        else:
            print("mage_last_rev_status returns unsupported status: {0}, exit with error".format(mage_last_rev_status))
            sys.exit(1)

        revision_line = "{0}searchmap_split:{1}".format(revision_prefix,
                                                        mage_last_rev_status["revision"])

        # 1. If new instance start
        if not os.path.isfile(REVISION_FILE_PATH):
            print("Revision file does't exists! Download fresh map.")
            with open(REVISION_FILE_PATH, 'w') as f:
                f.write("{0}\n".format(revision_line))

        # 2. If file exists - we need get revison from file and check with actual revision. If new revision doesn't
        # equals - we need download new map and fetch update hook.
        else:
            with open(REVISION_FILE_PATH, 'r') as f:
                revision_line_old = f.readlines()[0].strip()
            if revision_line_old == revision_line:
                print("Revision does't changed. old:{revision_line_old} new:{revision_line}"
                      .format(revision_line_old=revision_line_old,
                              revision_line=revision_line))
                sys.exit(0)
            else:
                print("Revision line is changed. Rewrite revision file. Old:{revision_line_old} new:{revision_line}"
                      .format(revision_line_old=revision_line_old,
                              revision_line=revision_line))
                with open(REVISION_FILE_PATH, 'w') as f:
                    f.write("{0}\n".format(revision_line))

        # 3. getmap here - if all dependencies is done
        with open(REVISION_FILE_PATH, 'r') as f:
            revision = f.readlines()[0].strip()

        mage_url = CLUSTER_URL.format(REVISION=revision,
                                      MAGE_URL=MAGE_URL)

        answer_map = make_auth_req_post(mage_url,
                                        token=OAUTH_TOKEN,
                                        timeout=20)

        with open(SEARCHMAP_PATH, 'w+') as f:
            f.write(answer_map)

        # 4. Reload all specified hooks
        for hook in RELOADMAP_HOOKS:
            reloadmap_url = hook['url'].format(PORT=int(env['BSCONFIG_IPORT']) + int(hook["port_offset"]))
            answer_hook = make_auth_req_post(reloadmap_url, token=OAUTH_TOKEN, timeout=60)
            print("Hook url: {0} Answer:{1}".format(reloadmap_url, answer_hook))

    except Exception as e:
        print("Cannot get latest searchmap version. Executing exception reached: {0}, exit with error".format(e))
        sys.exit(1)
