#!/usr/bin/python
from time import time
from yasmapi import GolovanRequest
import requests
import json
import sys

from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

file_hosts=sys.argv[1]

def make_auth_req( url,
                  token=None,
                  put=False,
                  post=False,
                  timeout=4000,
                  tries=1,
                  sleep=5):
    if put and post:
        print("Put and Post params defined. Error.")
        return False
    if token:
        headers = {"Authorization": "OAuth {0}".format(token),
                   "Content-Type": "application/json"}
    else:
        headers = {}
    attempts = 0
    while attempts < tries:
        if put:
            result = requests.put(url, headers=headers, json=put, timeout=timeout, verify=False)
        elif post:
            result = requests.post(url, headers=headers, json=post, timeout=timeout, verify=False)
        else:
            result = requests.get(url, headers=headers, timeout=timeout, verify=False)
        if result.status_code == 200 or result.status_code == 202:
            break
        else:
            print("error: {0} error text:{1}".format(result.status_code, result.text))
            attempts += 1
        if attempts == tries:
            print("Tries number reached")
            return False
        time.sleep(sleep)
    return result.text

def signal_list(itypelist):
    signals_list = []
    for idata in itypelist:    
        itype = type=idata['itype']    
        if not idata['ctype']:        
            ctype = "none"    
        else:        
            ctype = idata['ctype']    
        if not idata['prj']:        
            prj = "none";    
        else:        
            prj = idata['prj']
        signals_list.append("itype={itype}:portoinst-io_ops_/place_tmmv".format(itype=itype))
    return signals_list

def get_statbysignals(host, signals_list):
    host = "ASEARCH"
    count = 20 # how many periods get 20 * 5 = 100 minutes
    period = 300 #five minute data
    et = time() - period * 5
    st = et - period * count
    return GolovanRequest(host, period, st, et, signals_list)

stats={}

with open(file_hosts) as f:
    for host in f:
        hst=host.strip()
        url = "https://yasm.yandex-team.ru/metainfo/tags/?hosts={host}".format(host=hst)
        itypelist = json.loads(make_auth_req(url))['response']['result']
        signals=signal_list(itypelist)
        sgdata=get_statbysignals(host, signals)
        print ""
        print "Monitoring host: ",host
        for sg in sgdata:
            print ""
            print "Timestamp: ",sg[0]
            for itype,data in sg[1].iteritems():                
                hrtype=itype.split(":")[0].split("=")[1]
                if not stats.get(hrtype):
                    stats[hrtype] = int(data)
                else:
                    stats[hrtype]=stats[hrtype] + int(data)
                print("{itype},{data}".format(itype=hrtype, data=data))


#for sg in get_statbysignals(host, signals_list):
#     print sg[0]
#     for itype,data in sg[1].iteritems():
#         hrtype=itype.split(":")[0].split("=")[1]
#         print("{itype},{data}".format(itype=hrtype, data=data))

for itype, data in stats.iteritems():
    print itype, data
