#!/usr/bin/python3
import time
from yasmapi3 import GolovanRequest
import requests
import json
import sys

from requests.packages.urllib3.exceptions import InsecureRequestWarning
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

file_hosts=sys.argv[1]
monit_signal=sys.argv[2]
brk_treshold=sys.argv[3]
s_get_count=sys.argv[4]

time.sleep(2)

def make_auth_req( url,
                  token=None,
                  put=False,
                  post=False,
                  timeout=4000,
                  tries=1,
                  sleep=5):
    if put and post:
        print("Put and Post params defined. Error.")
        return False
    if token:
        headers = {"Authorization": "OAuth {0}".format(token),
                   "Content-Type": "application/json"}
    else:
        headers = {}
    attempts = 0
    while attempts < tries:
        if put:
            result = requests.put(url, headers=headers, json=put, timeout=timeout, verify=False)
        elif post:
            result = requests.post(url, headers=headers, json=post, timeout=timeout, verify=False)
        else:
            result = requests.get(url, headers=headers, timeout=timeout, verify=False)
        if result.status_code == 200 or result.status_code == 202:
            break
        else:
            print("error: {0} error text:{1}".format(result.status_code, result.text))
            attempts += 1
        if attempts == tries:
            print("Tries number reached")
            return False
        time.sleep(sleep)
    return result.text

def get_statbysignals(host, signals_list):
#    host = "ASEARCH"
#    host = "disk-search-backend-yp-prod-1739.vla.yp-c.yandex.net"
    count = int(s_get_count) # how many periods get 20 * 5 = 100 minutes
    period = 300 #five minute data
    #period = 86400 #two hours data
    et = time.time() - period * 5
    st = et - period * count
    print("SIGLIST", signals_list)
    return GolovanRequest(host, period, st, et, signals_list)

broken_hsts=set()

def get_hst_data(host):
#    signals=["itype=bacchus:portoinst-volume_/logs_usage_perc_txxx"]
#    signals=["itype=bacchus:index-index-copy-failed_ammt"]
    signals=[monit_signal]
    sgdata=get_statbysignals(host, signals)
    #print("SGDATA", sgdata)
    return sgdata

broken_hsts=set()
with open(file_hosts) as f:
    for host in f:
        hst=host.strip()
        flag = True
        while flag:
            try:
               sgdata=get_hst_data(hst)
    
               for sg in sgdata:
                   data = sg[1]
                   perc = data[monit_signal]
                   print("Working with host, data", hst, "Return data", perc)
                   if perc is None:
                       print("No data for host perc is None", hst)
                       continue
                   if perc >= int(brk_treshold):
                       print("Found broken host", hst, perc)
                       broken_hsts.add((hst, perc))
#               print("Broken hosts", broken_hsts)
            except Exception as e:
                print("Exception reached, rerun", e)
                time.sleep(2)
     
            flag=False

print("Broken hosts:")
for e in broken_hsts:
    print(e[0],e[1])

