import os

# import time
import nanny_rpc_client
from infra.nanny.yp_lite_api.proto import pod_sets_api_pb2
from infra.nanny.yp_lite_api.py_stubs import pod_sets_api_stub

from optparse import OptionParser

# cluster, spec, pod, shard


def setpodshard(label: str, cluster: str, spec: str, pod: str, service: str):

    c = nanny_rpc_client.RetryingRpcClient(rpc_url='https://yp-lite-ui.nanny.yandex-team.ru/api/yplite/pod-sets/',
                                           oauth_token=os.getenv('OAUTH'))
    stub = pod_sets_api_stub.YpLiteUIPodSetsServiceStub(c)
    req = pod_sets_api_pb2.GetPodRequest()

    res_cluster = f"{cluster}{spec}"
    req.pod_id = pod
    req.cluster = res_cluster

    # req.cluster = cluster
    # req.pod_id = pod

    answer = stub.get_pod(req)

    # nanny_version = ""
    for el in answer.pod.labels.attributes:
        print(el.key, el.value)
        # if el.key == 'nanny_version':
        # nanny_version = el.value.decode("utf-8")
        # break
    # print(f"DETECTED NANNY VERSION IS: {nanny_version}")

    c = nanny_rpc_client.RetryingRpcClient(rpc_url='https://yp-lite-ui.nanny.yandex-team.ru/api/yplite/pod-sets/',
                                           oauth_token=os.getenv('OAUTH'))

    stub = pod_sets_api_stub.YpLiteUIPodSetsServiceStub(c)
    req = pod_sets_api_pb2.UpdatePodRequest()

    res_cluster = f"{cluster}{spec}"

    req.pod_id = pod
    req.cluster = res_cluster

    # req.labels['nanny_service_id'] = service

    for att in answer.pod.labels.attributes:
        print(el.key, el.value)
        if att.key == 'nanny_version':
            req.version = att.value
            continue
        req.labels[att.key] = att.value

    req.labels['shard_id'] = label

    # req.labels['node'] = '{"cpu_model"="Intel(R) Xeon(R) CPU E5-2660 0 @ 2.20GHz";}'
    # req.labels['last_eviction_time'] = "1639558509"
    # req.labels['deploy_engine'] = "YP_LITE"
    # req.labels['deploy_engine_url'] = "https://nanny.yandex-team.ru/ui/#/services/catalog/aceventura_search_backend_prod/"
    # req.labels['hq_synced_eviction_time'] = "1639558682377998u"
    # req.version = "a86f8d80-f9b5-479c-9496-5ddd0ac2adf1"
    # req.labels['nanny_service_id'] = service

    # req.version = nanny_version

    print(stub.update_pod(req))


def main():
    parser = OptionParser()

    parser.add_option("-a", "--action",
                      type="string",
                      dest="action",
                      metavar="ACTION",
                      help="Specify one action: init, add")

    parser.add_option("-p", "--pod",
                      type="string",
                      dest="pod",
                      metavar="pod",
                      help="Set state for specific pod.")

    parser.add_option("--cluster",
                      type="string",
                      dest="cluster",
                      metavar="cluster",
                      help="Set cluster (SAS,MAN,VLA).")

    parser.add_option("--spec",
                      type="string",
                      dest="spec",
                      metavar="spec",
                      help="Specify additional cluster spec (EXT).")

    parser.add_option("--shard",
                      type="string",
                      dest="shard",
                      metavar="shard",
                      help="Specify pod shard for update.")

    parser.add_option("--service",
                      type="string",
                      dest="service",
                      metavar="service",
                      help="Specify pod shard for update.")

    # parser.add_option("--podnumber",
    #                   type="string",
    #                   dest="podnumber",
    #                   metavar="podnumber",
    #                   help="Set pod number. Pod name will be: mail-search-backend-prod-{podnumber}")

    (options, args) = parser.parse_args()

    action = options.action
    pod = options.pod
    cluster = options.cluster
    spec = options.spec
    shard = options.shard
    service = options.service
    # podnumber = options.podnumber

    if not action:
        print("Error! Action required!")
    elif action == "setpodshard":
        if cluster and pod and shard:
            if not spec:
                spec = ""
            # print(f"Add dom0 {dom0} label {label}")
            setpodshard(shard, cluster, spec, pod, service)
        else:
            print("Error! For editlabels action --cluster and --pod and --shard options is required!")
    # elif action == "set_state":
    #     if pod and snapshot and state and cluster:
    #         set_state(pod, snapshot, state, cluster)
    #     else:
    #         print("Error! Please specify -p (pod) -snapshot (snapshot) -state (state) --cluster")


if __name__ == '__main__':
    main()
