import logging
import json
import sys
import time
import requests
from urllib3.exceptions import InsecureRequestWarning
import urllib3

urllib3.disable_warnings(InsecureRequestWarning)


class GetInfo(object):

    def __init__(self, log):
        self.url_tries = 3
        self.url_sleep = 5

        self.gencfg_url = "http://api.gencfg.yandex-team.ru/"
        self.nanny_url = "https://nanny.yandex-team.ru/v2/"

        self.nanny_url_yp_list_pods = "https://yp-lite-ui.nanny.yandex-team.ru/api/yplite/pod-sets/ListPods/"

        self.oauth_token = "AQAD"
        self.log = log

    def make_auth_req(self,
                      url,
                      token=None,
                      put=None,
                      post=None,
                      timeout=900,
                      tries=1,
                      sleep=5):

        if put and post:
            self.log("Put and Post params defined. Error.")
            return False

        if token:
            headers = {"Authorization": "OAuth {0}".format(token),
                       "Content-Type": "application/json"}
        else:
            headers = {}

        attempts = 0
        while attempts < tries:
            if put:
                result = requests.put(url, headers=headers, json=put, timeout=timeout, verify=False)
            elif post:
                result = requests.post(url, headers=headers, json=post, timeout=timeout, verify=False)
            else:
                # self.log.info("Perform get request")
                result = requests.get(url, headers=headers, timeout=timeout, verify=False)
            # self.log.info(("status code: {0}".format(result.status_code)))
            if result.status_code == 200 or result.status_code == 202:
                break
            else:
                # self.log.info("error: {0} error text:{1}".format(result.status_code, result.text))
                attempts += 1
            if attempts == tries:
                # self.log.info("Tries number reached")
                return False
            time.sleep(sleep)
        return result.text

    def get_gencfg_release_full(self, serviceName, timeout=40):
        # returns dict with list with dicts from extended_gencfg_groups

        data = self.make_auth_req("{0}services/{1}/runtime_attrs/instances/".format(self.nanny_url, serviceName),
                                  timeout=timeout)
        if data:
            service_dict = json.loads(data)
            return service_dict
        else:
            return False

    def get_yp_group_resources(self, nanny, dc, timeout=40):
        post = {"serviceId": nanny,
                "cluster": dc,
                "fieldMask": "spec.resourceRequests,status.diskVolumeAllocations",
                "offset": 0,
                "limit": 100
                }
        gtype = "YP"

        data = self.make_auth_req(self.nanny_url_yp_list_pods, token=self.oauth_token, post=post, timeout=timeout)

        if data:
            dataj = json.loads(data)
            if dataj["total"] == 0:
                return False
            cpu_cores = int(dataj['pods'][0]['spec']['resourceRequests']['vcpuLimit']) / 1000
            inst_count = dataj['total']
            memoryGB = int(dataj['pods'][0]['spec']['resourceRequests']['memoryLimit']) / 1024.0 / 1024.0 / 1024
            ssd =0
            hdd = 0
            for volume in dataj['pods'][0]['status']['diskVolumeAllocations']:
                if volume['device'] == "/ssd":
                    ssd = ssd + int(volume['capacity'])
                if volume['device'] == "/place":
                    hdd = hdd + int(volume['capacity'])

            ssdGB = ssd / 1024 / 1024 / 1024
            diskGB = hdd / 1024 / 1024 / 1024

            s_data = self.make_auth_req("{0}services/{1}/info_attrs/".format(self.nanny_url,nanny),
                                        token=self.oauth_token,
                                        timeout=timeout)
            prj = json.loads(s_data)['content']['abc_group']
        else:
            cpu_cores = False
            inst_count = False
            memoryGB = False
            ssdGB = False
            diskGB = False
            prj = False

        return {"cpu": cpu_cores,
                "inst_count": inst_count,
                "ramGB": memoryGB,
                "ssdGB": ssdGB,
                "diskGB": diskGB,
                "prj": prj,
                "type": gtype}

    # https://api.gencfg.yandex-team.ru/trunk/groups/VLA_MAIL_LUCENE/card

    def get_gencfg_group_resources(self, gencfg_group, timeout=40):
        gtype = "GENCFG"
        data = self.make_auth_req("{0}trunk/groups/{1}/card".format(self.gencfg_url, gencfg_group), timeout=timeout)
        if data:
            dataj = json.loads(data)
            cpu_cores = dataj['reqs']['shards']['min_power'] / 40.0
            inst_count = dataj['resources']['ninstances']
            memoryGB = dataj['reqs']['instances']['memory_guarantee'] / 1024.0 / 1024.0 / 1024
            ssdGB = dataj['reqs']['instances']['ssd'] / 1024 / 1024 / 1024
            diskGB = dataj['reqs']['instances']['disk'] / 1024 / 1024 / 1024
            prj = dataj['tags']['metaprj']
        else:
            cpu_cores = False
            inst_count = False
            memoryGB = False
            ssdGB = False
            diskGB = False
            prj = False

        return {"cpu": cpu_cores,
                "inst_count": inst_count,
                "ramGB": memoryGB,
                "ssdGB": ssdGB,
                "diskGB": diskGB,
                "prj": prj,
                "type": gtype}

    def get_gencfg_last_revision(self, gencfg_url, timeout=20):
        data = self.make_auth_req("{0}{1}/tags".format(gencfg_url, "unstable"), timeout=timeout)
        dataj = json.loads(data)['displayed_tags']
        return dataj[2]
