import json
import logging
import os
import sys

import jinja2
import GetInfo

DATAFILE="data_main.json"
SERVICEFILE='search_services2021.txt'

# templateLoader = jinja2.FileSystemLoader(searchpath="./templates")
# templateEnv = jinja2.Environment(loader=templateLoader)
# TEMPLATE_FILE = "template.tmpl.txt"
# template = templateEnv.get_template(TEMPLATE_FILE)
# outputText = template.render()  # this is where to put args to the template renderer
#
# print(outputText)


log = logging.getLogger(__name__)
out_hdlr = logging.StreamHandler(sys.stdout)
out_hdlr.setFormatter(logging.Formatter('%(asctime)s %(message)s'))
out_hdlr.setLevel(logging.INFO)
log.addHandler(out_hdlr)
log.setLevel(logging.INFO)

getinfo = GetInfo.GetInfo(log)

def rendertemplate(render_dict):
    # {"parent": {"nanny":{"gencfg1": {"cpu": ...}
    #                      "gencfg2": {"cpu1": ...}
    #                      }
    #            }
    #  "parent2": ...
    # }

    templateLoader = jinja2.FileSystemLoader(searchpath="./templates")
    templateEnv = jinja2.Environment(loader=templateLoader, trim_blocks=True, lstrip_blocks=True)
    TEMPLATE_FILE = "services.tmpl.txt"
    template = templateEnv.get_template(TEMPLATE_FILE)
    outputText = template.render({'data': render_dict})
    print(outputText)

if os.path.isfile(DATAFILE):
    with open(DATAFILE, 'r') as f_in:
        render_dict = json.load(f_in)
    rendertemplate(render_dict)

if not os.path.isfile(DATAFILE):

    services_dict={}

    with open(SERVICEFILE) as f:
        for line in f:
            if not line.strip():
                pass
            else:
                if line.startswith("SERVICE:"):
                    servicen = line.strip().split(":")[1].strip()
                    services_dict[servicen] = set()
                else:
                   services_dict[servicen].add(line.strip())

    template_dict = {}

    for parent, nanny_list in services_dict.items():
        log.info(f"Working with: {parent}")
        template_dict[parent]={}
        for nanny in nanny_list:
            template_dict[parent][nanny] = {}
            groupdata = getinfo.get_gencfg_release_full(nanny)
            #print(groupdata)
            if not groupdata:
                log.error(f"Group {nanny} cannot be enqueued. Fix the list and try again!")
                sys.exit(1)

            if groupdata['content']['chosen_type'] == "EXTENDED_GENCFG_GROUPS":
                try:
                    for groupDetail in groupdata['content']['extended_gencfg_groups']['groups']:
                        gencfg_group = groupDetail['name']
                        template_dict[parent][nanny][gencfg_group] = getinfo.get_gencfg_group_resources(gencfg_group)
                except KeyError as e:
                    log.info(f"Gencfg groups doesnot found, but type = gencfg. Nanny service: {nanny}")
            else:
                log.info(f"Nanny service have yp type, so trying to get yp resources service: {nanny}")
                for dc in ["SAS","MAN","VLA","IVA","MYT"]:
                    yp_groupdata = getinfo.get_yp_group_resources(nanny,
                                                                  dc)
                    if yp_groupdata:
                        template_dict[parent][nanny][dc] = yp_groupdata

    with open(DATAFILE, 'w') as f:
        json.dump(template_dict, f)
