from yp.client import YpClient
import os
from optparse import OptionParser

# Just test client for get info from yp api

if "_OAUTH_TOKEN_" in os.environ:
    token = os.environ['_OAUTH_TOKEN_']
else:
    token = None


def get_evicted(service, cluster):
    for cluster in cluster.split(","):
        filter = f'[/meta/pod_set_id] = "{service}" AND ([/status/eviction/state] = "requested" AND ([/status/eviction/reason] != "hfsm" OR [/status/maintenance/state] = "requested"))'
        client = YpClient(cluster, config={"token": token})

        for fields in client.select_objects("pod", filter=filter, selectors=["/meta/id", "/status/maintenance"]):
            # print(fields[0], fields[1]['state'])
            print(f'{cluster.upper()} {fields[0]} {fields[1]}')


def main():
    parser = OptionParser()

    parser.add_option("-s", "--service",
                      type="string",
                      dest="service",
                      metavar="SERVICE",
                      help="Select service to get evicted pods: mail-search-backend-prod,disk-search-backend-yp-prod")

    parser.add_option("-c", "--cluster",
                      type="string",
                      dest="cluster",
                      metavar="CLUSTER",
                      help="Specify clusters: man,sas,vla")

    (options, args) = parser.parse_args()

    service = options.service
    cluster = options.cluster
    get_evicted(service, cluster)

if __name__ == '__main__':
    main()
