# All known projects list
projects := \
    aceventura-backend \
    aceventura-backend-config \
    aceventura-base \
    aceventura-proxy \
    aceventura-salo \
    asyncserver \
    bacchus \
    bacchus-config \
    base64 \
    benchmark \
    benchmarks \
    blackbox \
    build-utils \
    charset \
    cityhash \
    cocaine-client \
    cocaine-http-worker \
    cocaine-storage-utils \
    cocaine-worker \
    cokemulator \
    cokemulator-srw \
    collections \
    compress \
    concurrent \
    concurrentlinkedhashmap \
    config-generator \
    config-parser \
    coverage-builder \
    dbfields \
    digest \
    disk-callbacks-config \
    disk-indexer \
    disk-indexer-service \
    disk-indexer-service-config \
    disk-search-base \
    disk-search-fields \
    dispatcher-zk \
    district-backend \
    district-backend-config \
    district-base \
    district-indexer \
    district-search-proxy \
    email-parser \
    email-types \
    erratum \
    fast-md5 \
    filesystem-utils \
    function \
    gatemail \
    geocoder \
    gorgophone \
    html-parser \
    htmlutils \
    http-config \
    http-nio-utils \
    http-proxy \
    http-test \
    http-utils \
    httpasyncclient-utils \
    httpclient-utils \
    httprequest-utils \
    httpserver \
    httpserver-utils \
    iex-proxy \
    io \
    ip-utils \
    jniwrapper \
    jrbld \
    jrbld-queue-config \
    jrbld-service \
    jrbld-service-base \
    jrbld-service-config \
    json \
    json-async-consumer \
    json-dom \
    json-parser \
    json-simple \
    json-writer \
    json-xpath \
    junk \
    jute \
    kali \
    kamaji \
    lb-logger \
    lemmer \
    ljinx \
    lmdb-cache \
    logbroker-consumer \
    logbroker2-consumer \
    logger \
    logrotate-incremental \
    lstorage \
    lucene \
    lucene-disk-config \
    lucene-mail-config \
    lucene-service-base \
    mail-document \
    mail-extract \
    mail-extract-config \
    mail-search-base \
    mail-search-strings \
    major \
    malo \
    matrixnet \
    moxy \
    msal \
    msearch-proxy \
    mulcagate \
    multistarter \
    nanny-service-base \
    nginx-cache-config \
    ocr-proxy \
    pdfclown \
    peach \
    perseus \
    perseus-config \
    pg-indexer \
    producer-client \
    projects-checkstyle \
    protobuf \
    query-parser \
    request-utils \
    salo \
    sanitizer-service \
    sanitizer-service-config \
    sanitizer2 \
    sanitizer2-config \
    search-document \
    search-json \
    search-prefix \
    search-proxy \
    search-result \
    search-rules \
    searchmap \
    searchmap-generator \
    senders \
    sharpei \
    shivaka \
    so-lsa-ljinx-config \
    spampkin \
    spampkin-config \
    spdaemon-accessories \
    spdaemon-accessories-config \
    sqlite-cache \
    staff-consumer \
    stater \
    storage-utils \
    string-parsers \
    string-utils \
    sun-text-normalizer \
    taksa-service-config \
    test-lucene \
    test-utils \
    tikaite \
    tikaite-srw \
    timesource \
    tskv \
    ttsbackend \
    ttsproxy \
    tupita \
    tvm-client \
    tvm2-client \
    unicode-utils \
    universal-search-proxy \
    unsafe \
    uri-parser \
    webtools \
    wmi-client \
    xavier \
    xml-xpath \
    yadisk-search-proxy \
    yt-consumer \
    zoolooser \
    zora-proxy

# version of jacoco
jacoco-version := 0.8.1

# common libraries aliases
commons-cli := lib/commons-cli-1.3.1.jar
commons-collections := lib/commons-collections-3.2.2.jar
commons-io := lib/commons-io-2.4.jar
commons-lang := lib/commons-lang3-3.4.jar
commons-logging := lib/commons-logging-1.2.jar
commons-text := $(commons-lang) lib/commons-text-1.4.jar

tcmalloc := lib/libstdc++.so lib/libstdc++.so.6 lib/libstdc++.so.6.0.22 lib/libtcmalloc_minimal.so lib/libtcmalloc_minimal.so.4.5.3

guava := lib/error_prone_annotations-2.3.1.jar lib/guava-25.0-jre.jar

jctools := lib/jctools-core-2.2-SNAPSHOT.jar

joda-time := lib/joda-time-2.9.jar

httpcore := \
    lib/httpcore-4.4.12-fb38b824b5158fdb17bb59ba72ff260fc3c272ee+patches.jar
httpcore-nio := \
    $(httpcore) \
    lib/httpcore-nio-4.4.12-fb38b824b5158fdb17bb59ba72ff260fc3c272ee+patches.jar
httpclient := \
    $(commons-logging) \
    $(httpcore) \
    lib/httpclient-4.5.10-c1e2339f0f70dd241898521eac2f1ff143987b57+patches.jar
httpmime := \
    $(httpclient) \
    lib/httpmime-4.5.10-c1e2339f0f70dd241898521eac2f1ff143987b57+patches.jar
httpasyncclient := $(sort \
    $(httpclient) \
    $(httpcore-nio) \
    lib/httpasyncclient-4.1.5-94b061bae5fe247cf3e69b487a78b457f20ca2e2+patches.jar)

junit := lib/hamcrest-core-1.3.jar lib/junit-4.11.jar

log4j := lib/log4j-1.2.17.jar

mime4j := \
    lib/apache-mime4j-core-0.8.3-66a87ba.jar \
    lib/apache-mime4j-dom-0.8.3-66a87ba.jar

cocaine-version := 0.12.0.1-SNAPSHOT
cocaine := \
    lib/cocaine-client-$(cocaine-version).jar \
    lib/cocaine-core-$(cocaine-version).jar \
    lib/cocaine-hpack-$(cocaine-version).jar

jsr := lib/jsr305-3.0.1.jar

slf4j := $(log4j) lib/slf4j-api-1.7.25.jar

concurrentlinkedhashmap := $(jsr) lib/concurrentlinkedhashmap-lru-1.4.2.jar

logbroker-grpc := \
    $(guava) \
    $(httpmime) \
    $(slf4j) \
    lib/api-grpc-draft.jar \
    lib/api-protos.jar \
    lib/grpc-context-1.12.0.jar \
    lib/grpc-core-1.12.0.jar \
    lib/grpc-netty-1.12.0.jar \
    lib/grpc-protobuf-1.12.0.jar \
    lib/grpc-protobuf-lite-1.12.0.jar \
    lib/grpc-stub-1.12.0.jar \
    lib/kikimr-core-protos.jar \
    lib/kikimr-persqueue-client-java.jar \
    lib/library-actors-protos.jar \
    lib/lzo-core-1.0.5.jar \
    lib/netty-buffer-4.1.22.Final.jar \
    lib/netty-codec-4.1.22.Final.jar \
    lib/netty-codec-http-4.1.22.Final.jar \
    lib/netty-codec-http2-4.1.22.Final.jar \
    lib/netty-common-4.1.22.Final.jar \
    lib/netty-handler-4.1.22.Final.jar \
    lib/netty-resolver-4.1.22.Final.jar \
    lib/netty-transport-4.1.22.Final.jar \
    lib/opencensus-api-0.11.0.jar \
    lib/opencensus-contrib-grpc-metrics-0.11.0.jar \
    lib/protobuf-java-3.5.1.jar \
    lib/slf4j-log4j12-1.7.25.jar

bc-version := jdk15on-161-5c199d6ee614408b66f834310f7bb0c9c5fdf329+patches
bctls := lib/bcprov-$(bc-version).jar lib/bctls-$(bc-version).jar

xerces := lib/xercesImpl-2.12.0.jar lib/xml-apis-2.12.0.jar

# Each project has the following properties:
# skip-checks	- flag indicating that various checkstyle and spotbugs checks
#		shouldn't be applied to this project
# main-deps	- list of projects this project is dependent on
# main-libs	- list of *.jar files required by this package
# main-dlls	- list of *.so files required by this package
# test-deps	- list of projects this project tests is dependent on
# test-libs	- list of *.jar files required to run tests on this package
# test-dlls	- list of *.so files required to run tests on this package
# java-opts	- list of additional jvm parameters required for tests

htmlutils-skip-checks := true
json-skip-checks := true
json-simple-skip-checks := true
junk-skip-checks := true
jute-skip-checks := true
pdfclown-skip-checks := true
perseus-skip-checks := true
cityhash-skip-checks := true
protobuf-skip-checks := true
protobuf-main-libs := lib/protobuf-java-3.5.1.jar

base64-main-deps := io
base64-test-deps := charset

charset-main-deps := function
charset-main-libs := lib/jcharset-1.6.jar

collections-main-deps := function
collections-test-deps := test-utils

concurrent-main-deps := function timesource
concurrent-main-libs := $(jctools)
concurrent-test-deps := collections test-utils

io-main-deps := string-utils

coverage-builder-main-libs := lib/jacocoant-$(jacoco-version).jar

search-json-main-deps := json-parser search-prefix

json-writer-main-deps := io string-parsers unicode-utils

json-xpath-main-deps := json-parser string-parsers

junk-main-deps := lucene

perseus-main-deps := \
    dispatcher-zk \
    kamaji \
    ljinx \
    peach

perseus-config-main-deps := \
    logrotate-incremental \
    lucene-mail-config \
    mail-search-base

compress-main-dlls :=  build/libcompress.so build/libzlib_fast.so
compress-skip-checks := true

http-utils-main-deps := build-utils charset compress io string-parsers
http-utils-main-libs := $(httpcore)

httprequest-utils-main-deps := http-config query-parser uri-parser

httpserver-utils-main-deps := logger stater tvm2-client
httpserver-utils-test-libs := $(junit)

httpserver-main-deps := httpserver-utils
httpserver-main-libs := $(httpclient)
httpserver-test-deps := http-test

search-document-main-deps := json-writer

mail-document-main-deps := \
    base64 \
    dbfields \
    email-parser \
    email-types \
    json-dom \
    json-xpath \
    query-parser \
    search-document

tikaite-main-deps := \
    html-parser \
    httpserver \
    jniwrapper \
    mail-document \
    pdfclown \
    sanitizer2 \
    storage-utils \
    xml-xpath
tikaite-main-libs := $(xerces) lib/pngj-2.1.1.jar lib/tika-app-1.16.jar
tikaite-test-deps := http-test
tikaite-test-dlls := build/libjniwrapper-test.so
tikaite-java-opts := \
    -Djavax.xml.accessExternalDTD= \
    -Djavax.xml.accessExternalSchema= \
    -Xmx2G

tikaite-srw-main-deps := cocaine-storage-utils sanitizer2-config tikaite

tskv-main-deps := http-nio-utils logger
tskv-test-deps := http-test

logbroker-consumer-main-deps := \
    blackbox \
    dbfields \
    http-proxy \
    json-simple \
    searchmap \
    tskv
logbroker-consumer-test-deps := http-test
logbroker-consumer-main-libs := $(guava)

lemmer-main-dlls := lemmer/liblemmer-ng.so

lucene-skip-checks := true
lucene-main-deps := \
    base64 \
    concurrentlinkedhashmap \
    htmlutils \
    httpserver \
    json \
    lemmer \
    lmdb-cache \
    search-json 
#    sqlite-cache
lucene-main-libs := $(guava)
lucene-main-dlls := $(tcmalloc)
lucene-test-deps := test-lucene

msal-main-deps := dbfields httpserver sharpei
msal-test-deps := http-test
msal-main-libs := lib/postgresql-42.2.1.jar

searchmap-main-deps := config-parser search-prefix
searchmap-main-libs := $(httpcore)
searchmap-test-deps := test-utils

yadisk-search-proxy-main-deps := \
    disk-search-base \
    disk-search-fields \
    geocoder \
    jniwrapper \
    logrotate-incremental \
    search-rules \
    universal-search-proxy
yadisk-search-proxy-main-libs := $(commons-text)
yadisk-search-proxy-test-deps := test-lucene
yadisk-search-proxy-test-dlls := build/libjniwrapper-test.so

matrixnet-main-deps := \
    config-parser
matrixnet-test-deps := \
    test-utils

msearch-proxy-skip-checks := true
msearch-proxy-main-deps := \
    htmlutils \
    json \
    json-simple \
    logrotate-incremental \
    mail-search-base \
    matrixnet \
    search-json \
    search-rules \
    tskv \
    universal-search-proxy \
    wmi-client
msearch-proxy-main-libs := \
    $(commons-collections) \
    $(commons-io) \
    $(commons-lang) \
    $(guava) \
    $(mime4j) \
    $(xerces) \
    lib/patricia-trie-0.6.jar
msearch-proxy-test-libs := $(commons-collections) $(commons-lang)
msearch-proxy-test-deps := test-lucene
msearch-proxy-java-opts := -Xmx1G

zoolooser-skip-checks := true
zoolooser-main-deps := jute lucene
zoolooser-main-libs := \
    $(commons-cli) \
    $(guava) \
    $(slf4j) \
    lib/jline-0.9.94.jar \
    lib/lucene4-analyzers-common-4.3-SNAPSHOT.jar \
    lib/lucene4-codecs-4.3-SNAPSHOT.jar \
    lib/lucene4-core-4.3-SNAPSHOT.jar \
    lib/lz4-1.2.0.jar \
    lib/netty-3.6.2.Final.jar \
    lib/patricia-trie-0.6.jar \
    lib/slf4j-log4j12-1.7.25.jar
zoolooser-mail-dlls := build/libldpreload.so

dispatcher-zk-skip-checks := true
dispatcher-zk-main-deps := \
    http-proxy \
    json-async-consumer \
    json-simple \
    tvm-client \
    zoolooser
dispatcher-zk-main-libs := \
    $(httpasyncclient) \
    $(mime4j) \
    $(xerces) \
    lib/compress-lzf-0.9.6-SNAPSHOT.jar
dispatcher-zk-test-deps := http-test
dispatcher-zk-test-libs := $(httpmime)

uri-parser-main-deps := http-utils
uri-parser-test-deps := base64 test-utils

config-parser-main-deps := filesystem-utils string-parsers string-utils
config-parser-test-deps := test-utils

logger-main-deps := httprequest-utils json-writer timesource
logger-main-libs := $(jctools) $(joda-time)

http-config-main-deps := config-parser
http-config-main-libs := $(bctls) $(httpcore)

asyncserver-main-deps := http-nio-utils httpserver-utils
asyncserver-main-libs := $(httpcore-nio)
asyncserver-test-deps := http-test json-async-consumer

http-test-main-deps := httpasyncclient-utils httpserver test-utils
http-test-main-libs := $(httpclient) $(mime4j)

json-async-consumer-main-deps := http-nio-utils json-dom json-xpath

http-proxy-main-deps := asyncserver httpasyncclient-utils

search-result-main-deps := json-writer json-xpath
search-result-main-libs := $(httpcore)

search-proxy-main-deps := \
    http-proxy \
    json-async-consumer \
    search-result \
    searchmap
search-proxy-test-deps := http-test

search-prefix-main-deps := json-writer

unicode-utils-main-deps := unsafe

ocr-proxy-main-deps := disk-search-fields http-proxy json-async-consumer request-utils tvm-client
ocr-proxy-test-deps := test-lucene

httpclient-utils-main-deps := http-config http-utils
httpclient-utils-main-libs := $(httpclient)
httpclient-utils-test-deps := http-test

http-nio-utils-main-deps := http-utils
http-nio-utils-main-libs := $(httpcore-nio)

httpasyncclient-utils-main-deps := http-nio-utils httpserver-utils
httpasyncclient-utils-main-libs := $(httpasyncclient)
httpasyncclient-utils-test-deps := http-test
httpasyncclient-utils-test-libs := $(guava)

json-parser-main-deps := function
json-parser-test-deps := json-dom test-utils
json-parser-benchmark-deps := json-dom

json-dom-main-deps := json-parser json-writer
json-dom-test-deps := json-xpath

salo-main-deps := dbfields httpserver
salo-main-libs := $(httpmime)
salo-test-deps := http-test

erratum-main-deps := httpasyncclient-utils json-async-consumer

string-parsers-main-deps := collections
string-parsers-test-deps := test-utils

email-parser-main-deps := charset
email-parser-main-libs := $(mime4j)

email-types-main-deps := function

gatemail-main-deps := httpserver
gatemail-main-libs := $(httpmime)

geocoder-main-deps := \
    httpasyncclient-utils \
    protobuf
geocoder-test-deps := http-test

blackbox-main-deps := httpasyncclient-utils json-async-consumer
blackbox-test-deps := http-test

iex-proxy-main-deps := \
    fast-md5 \
    geocoder \
    html-parser \
    lb-logger \
    logrotate-incremental \
    mail-search-strings \
    nanny-service-base \
    tvm-client \
    universal-search-proxy \
    wmi-client
iex-proxy-main-libs := $(commons-lang) $(guava) $(httpmime) lib/netty-common-4.1.22.Final.jar
iex-proxy-test-deps := cokemulator test-lucene tikaite
iex-proxy-java-opts := -Xmx1G

kamaji-main-deps := search-proxy senders tvm-client wmi-client
kamaji-test-deps := test-lucene

senders-main-deps := blackbox mail-document

sharpei-main-deps := httpasyncclient-utils json-async-consumer
sharpei-test-deps := http-test

benchmark-main-deps := function

benchmarks-main-deps := benchmark

test-lucene-main-deps := \
    http-test \
    lucene \
    lucene-disk-config \
    lucene-mail-config \
    searchmap

request-utils-main-deps := string-utils

pg-indexer-main-deps := dbfields http-proxy json-async-consumer
pg-indexer-main-libs := $(httpmime)
pg-indexer-test-deps := http-test

mulcagate-main-deps := httpasyncclient-utils

string-utils-main-deps := function sun-text-normalizer
string-utils-test-deps := io test-utils

shivaka-main-deps := http-proxy searchmap
shivaka-test-deps := http-test
shivaka-main-dlls := $(tcmalloc)

producer-client-main-deps := \
    httpasyncclient-utils \
    json-async-consumer \
    searchmap
producer-client-test-deps := http-test

test-utils-main-libs := $(junit)

cokemulator-main-deps := \
    httpserver \
    jniwrapper \
    mulcagate \
    storage-utils \
    tvm-client
cokemulator-main-libs := $(mime4j)
cokemulator-test-deps := http-test
cokemulator-test-dlls := build/libjniwrapper-test.so

cokemulator-srw-main-deps := cocaine-storage-utils cokemulator

stater-main-deps := concurrent httprequest-utils

storage-utils-main-deps := base64 httpserver-utils
storage-utils-main-libs := $(mime4j)

search-rules-main-deps := \
    blackbox \
    erratum \
    http-proxy \
    producer-client \
    request-utils

peach-main-deps := \
    httpasyncclient-utils \
    httpserver \
    search-prefix \
    search-result
peach-test-deps := test-lucene

bacchus-main-deps := \
    dispatcher-zk \
    kali \
    ljinx \
    ocr-proxy \
    peach

bacchus-config-main-deps := \
    disk-search-base \
    logrotate-incremental \
    lucene-disk-config

wmi-client-main-deps := json-async-consumer mail-document request-utils

cocaine-client-main-deps := concurrent config-parser io
cocaine-client-main-libs := \
    $(cocaine) \
    $(joda-time) \
    lib/javassist-3.20.0-GA.jar \
    lib/org.msgpack-msgpack-bundle-0.6.11.jar

cocaine-worker-main-deps := cocaine-client
cocaine-worker-main-libs := lib/juds-0.94.1.jar

cocaine-http-worker-main-deps := cocaine-worker httpserver-utils

ljinx-main-deps := fast-md5 search-proxy
ljinx-main-libs := $(concurrentlinkedhashmap)
ljinx-test-deps := test-lucene

disk-indexer-main-deps := http-proxy json-async-consumer
disk-indexer-main-libs := $(httpmime)
disk-indexer-test-deps := http-test

disk-indexer-service-main-deps := disk-indexer dispatcher-zk multistarter

disk-indexer-service-config-main-deps := \
    disk-search-base \
    logrotate-incremental \
    searchmap-generator

tvm-client-main-deps := base64 httpclient-utils
tvm-client-main-libs := lib/commons-codec-1.10.jar

tvm2-client-main-deps := httpclient-utils json-dom
tvm2-client-main-libs := lib/ticket_parser2-r3191730.jar
tvm2-client-main-dlls := lib/libticket_parser2_java.so

jniwrapper-main-deps := concurrent config-parser io
jniwrapper-main-dlls := build/libjniwrapper-main.so

zora-proxy-main-deps := http-proxy
zora-proxy-test-deps := http-test
zora-proxy-main-libs := \
    $(commons-io) \
    $(commons-lang) \
    $(guava)

xavier-main-deps := blackbox dbfields dispatcher-zk producer-client request-utils search-proxy
xavier-test-deps := http-test

fast-md5-skip-checks := true
fast-md5-main-deps := function
fast-md5-main-dlls := build/libfast-md5.so

universal-search-proxy-main-deps := producer-client search-proxy
universal-search-proxy-test-deps := http-test

tupita-main-deps := kamaji lb-logger ljinx lucene multistarter tikaite
tupita-test-deps := test-lucene

mail-extract-main-deps := cokemulator ljinx lucene multistarter

ttsproxy-main-deps := gorgophone universal-search-proxy

gorgophone-main-deps := request-utils search-proxy

ttsbackend-main-deps := dispatcher-zk multistarter ttsproxy

yt-consumer-main-deps := blackbox http-proxy request-utils tskv
yt-consumer-test-deps := http-test
yt-consumer-main-libs := $(commons-lang) $(guava) $(httpmime) $(joda-time)

staff-consumer-main-deps := http-proxy json-async-consumer
staff-consumer-test-deps := test-lucene

lstorage-main-deps := dispatcher-zk multistarter universal-search-proxy

major-main-deps := logrotate-incremental nanny-service-base search-proxy
major-test-deps := http-test
major-main-libs := $(concurrentlinkedhashmap) $(guava)

webtools-main-deps := \
    dispatcher-zk \
    lucene-service-base \
    mail-document \
    mail-search-strings \
    universal-search-proxy
webtools-main-libs := $(joda-time) lib/thumbnailator-0.4.8.jar
webtools-test-deps := http-test

sanitizer-service-main-deps := sanitizer2

sanitizer-service-config-main-deps := \
    logrotate-incremental \
    nanny-service-base \
    sanitizer2-config

sanitizer2-main-deps := asyncserver fast-md5
sanitizer2-main-libs := \
    $(guava) \
    $(httpmime) \
    $(jsr) \
    $(slf4j) \
    lib/owasp-java-html-sanitizer-20180219.2-SNAPSHOT.jar \
    lib/ph-commons-9.1.2.jar \
    lib/ph-css-6.1.2-bd267e3+patches.jar
sanitizer2-test-deps := http-test sanitizer2-config

kali-main-deps := disk-search-fields http-proxy json-async-consumer request-utils tvm-client
kali-test-deps := ocr-proxy test-lucene tikaite

concurrentlinkedhashmap-main-libs := $(jctools) $(jsr)
concurrentlinkedhashmap-skip-checks := true

sun-text-normalizer-skip-checks := true

logbroker2-consumer-main-deps := \
    http-proxy \
    nanny-service-base
logbroker2-consumer-main-libs := $(logbroker-grpc)

malo-main-deps := \
    base64 \
    cityhash \
    http-proxy \
    json-async-consumer \
    nanny-service-base \
    protobuf \
    searchmap
malo-main-libs := \
    $(concurrentlinkedhashmap) \
    $(httpmime) \
    $(mime4j)

lucene-service-base-main-deps := nanny-service-base

disk-search-base-main-deps := lucene-service-base
mail-search-base-main-deps := lucene-service-base

moxy-main-deps := \
    base64 \
    logrotate-incremental \
    lucene-service-base \
    protobuf \
    search-rules \
    universal-search-proxy
moxy-main-libs := $(commons-text)
moxy-test-deps := test-lucene
moxy-test-dlls := build/libjniwrapper-test.so

filesystem-utils-main-deps := function

lb-logger-main-deps := httpserver-utils
lb-logger-main-libs := $(logbroker-grpc)

mail-search-strings-main-deps := blackbox searchmap

config-generator-main-libs := \
    $(guava) \
    $(jsr) \
    lib/javaparser-core-3.7.0.jar \
    lib/javassist-3.20.0-GA.jar

config-generator-skip-checks := true

disk-search-fields-main-deps := http-utils json-dom

cocaine-storage-utils-main-deps := cocaine-http-worker storage-utils

taksa-service-config-main-deps := \
    nanny-service-base

district-search-proxy-main-deps := \
    base64 \
    district-base \
    logrotate-incremental \
    lucene-service-base \
    search-rules \
    universal-search-proxy
district-search-proxy-main-libs := $(commons-io) $(guava) lib/tika-app-1.16.jar
district-search-proxy-test-deps := test-lucene

district-backend-main-deps := \
    dispatcher-zk \
    multistarter

district-backend-config-main-deps := \
    logrotate-incremental \
    lucene-service-base

district-indexer-main-deps := \
    dispatcher-zk \
    district-base \
    logrotate-incremental \
    nanny-service-base

district-indexer-main-libs := $(httpmime)
district-indexer-test-deps := test-lucene

aceventura-base-skip-checks := true
aceventura-base-main-deps := \
    search-prefix

aceventura-proxy-skip-checks := true
aceventura-proxy-main-deps := \
    aceventura-base \
    logrotate-incremental \
    nanny-service-base \
    search-json \
    search-rules \
    universal-search-proxy

aceventura-proxy-test-deps := test-lucene

aceventura-backend-skip-checks := true

aceventura-backend-main-deps := \
    dispatcher-zk \
    logrotate-incremental \
    lucene-service-base \
    multistarter

aceventura-salo-skip-checks := true
aceventura-salo-main-deps := \
    aceventura-base \
    dispatcher-zk \
    email-parser \
    logrotate-incremental \
    multistarter \
    nanny-service-base \
    salo
aceventura-salo-test-deps := \
    test-lucene

so-lsa-ljinx-config-main-deps := logrotate-incremental nanny-service-base

sqlite-cache-main-dlls := build/libsqlite-cache.so
sqlite-cache-main-deps := timesource unsafe
sqlite-cache-test-deps := filesystem-utils test-utils unsafe

jrbld-main-deps := ip-utils jniwrapper universal-search-proxy
jrbld-test-deps := test-lucene
jrbld-test-dlls := build/libjniwrapper-test.so

jrbld-queue-config-main-deps := jrbld-service-base nanny-service-base

jrbld-service-base-main-deps := logrotate-incremental

jrbld-service-main-deps := dispatcher-zk jrbld

jrbld-service-config-main-deps := \
    jrbld-service-base \
    lucene-service-base

ip-utils-main-deps := config-parser

digest-main-deps := string-utils

spampkin-main-deps := digest http-proxy ip-utils json-async-consumer
spampkin-test-deps := http-test

spampkin-config-main-deps := nanny-service-base

spdaemon-accessories-main-deps := multistarter spampkin tikaite

spdaemon-accessories-config-main-deps := \
    logrotate-incremental \
    sanitizer2-config \
    spampkin-config

lmdb-cache-main-dlls := build/liblmdb-cache.so
lmdb-cache-main-deps := sqlite-cache
lmdb-cache-test-deps := filesystem-utils test-utils

disk-callbacks-config-main-deps := \
    disk-search-base \
    logrotate-incremental

 
