package ru.yandex.tools.benchmark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class BenchmarkCycle {
    private final BenchmarkOptions options;
    private final List<? extends Supplier<? extends Callable<?>>> benchs;
    private final Object etalon;
    private long bestTiming = Long.MAX_VALUE;
    private Callable<?> bestBench = null;
    private int cycleNumber = 0;

    public BenchmarkCycle(
        final BenchmarkOptions options,
        final List<? extends Supplier<? extends Callable<?>>> benchs)
        throws Exception
    {
        this.options = options;
        this.benchs = benchs;
        etalon = benchs.get(0).get().call();
    }

    public long[] benchmark() throws Exception {
        long[] timings = new long[benchs.size()];
        Arrays.fill(timings, Long.MAX_VALUE);
        ++cycleNumber;
        BenchmarkIteration iteration =
            new BenchmarkIteration(options, bestTiming, bestBench);
        if (options.gcSleep() > 0L) {
            System.gc();
            Thread.sleep(options.gcSleep());
        }
        List<Callable<?>> benchs = new ArrayList<>(this.benchs.size());
        for (Supplier<? extends Callable<?>> bench: this.benchs) {
            benchs.add(bench.get());
        }
        for (int i = 0; i < options.benchmarkIterations(); ++i) {
            long[] iterationTimings =
                iteration.benchmark(cycleNumber, benchs, etalon);
            Benchmark.mergeTimings(timings, iterationTimings);
        }
        bestTiming = iteration.bestTiming();
        bestBench = iteration.bestBench();
        return timings;
    }
}

