package ru.yandex.tools.benchmark;

import java.io.PrintStream;

public class BenchmarkOptions {
    public static final int DEFAULT_REPEATS = 10;
    public static final int DEFAULT_BENCHMARK_ITERATIONS = 100;
    public static final int DEFAULT_WARMUP_ITERATIONS = 1000;
    public static final int DEFAULT_WARMUP_CYCLES = 10;
    public static final int DEFAULT_WARMUP_REPEATS = 10;
    public static final int DEFAULT_SMALL_PREALLOC_SIZE = 1000;
    public static final int DEFAULT_SMALL_PREALLOC_COUNT = 100000;
    public static final int DEFAULT_BIG_PREALLOC_SIZE = 10000000;
    public static final int DEFAULT_BIG_PREALLOC_COUNT = 10;
    public static final long DEFAULT_STATUS_INTERVAL = 3000L;
    public static final long DEFAULT_GC_SLEEP = 1000L;

    private long lastStatusTime = System.currentTimeMillis();
    private int repeats = DEFAULT_REPEATS;
    private int benchmarkIterations = DEFAULT_BENCHMARK_ITERATIONS;
    private int warmupIterations = DEFAULT_WARMUP_ITERATIONS;
    private int warmupCycles = DEFAULT_WARMUP_CYCLES;
    private int warmupRepeats = DEFAULT_WARMUP_REPEATS;
    private int smallPreallocSize = DEFAULT_SMALL_PREALLOC_SIZE;
    private int smallPreallocCount = DEFAULT_SMALL_PREALLOC_COUNT;
    private int bigPreallocSize = DEFAULT_BIG_PREALLOC_SIZE;
    private int bigPreallocCount = DEFAULT_BIG_PREALLOC_COUNT;
    private long statusInterval = DEFAULT_STATUS_INTERVAL;
    private long gcSleep = DEFAULT_GC_SLEEP;
    private PrintStream out = System.out;

    public int repeats() {
        return repeats;
    }

    public BenchmarkOptions repeats(final int repeats) {
        this.repeats = repeats;
        return this;
    }

    public int benchmarkIterations() {
        return benchmarkIterations;
    }

    public BenchmarkOptions benchmarkIterations(
        final int benchmarkIterations)
    {
        this.benchmarkIterations = benchmarkIterations;
        return this;
    }

    public int warmupIterations() {
        return warmupIterations;
    }

    public BenchmarkOptions warmupIterations(final int warmupIterations) {
        this.warmupIterations = warmupIterations;
        return this;
    }

    public int warmupCycles() {
        return warmupCycles;
    }

    public BenchmarkOptions warmupCycles(final int warmupCycles) {
        this.warmupCycles = warmupCycles;
        return this;
    }

    public int warmupRepeats() {
        return warmupRepeats;
    }

    public BenchmarkOptions warmupRepeats(final int warmupRepeats) {
        this.warmupRepeats = warmupRepeats;
        return this;
    }

    public int smallPreallocSize() {
        return smallPreallocSize;
    }

    public BenchmarkOptions smallPreallocSize(final int smallPreallocSize) {
        this.smallPreallocSize = smallPreallocSize;
        return this;
    }

    public int smallPreallocCount() {
        return smallPreallocCount;
    }

    public BenchmarkOptions smallPreallocCount(final int smallPreallocCount) {
        this.smallPreallocCount = smallPreallocCount;
        return this;
    }

    public int bigPreallocSize() {
        return bigPreallocSize;
    }

    public BenchmarkOptions bigPreallocSize(final int bigPreallocSize) {
        this.bigPreallocSize = bigPreallocSize;
        return this;
    }

    public int bigPreallocCount() {
        return bigPreallocCount;
    }

    public BenchmarkOptions bigPreallocCount(final int bigPreallocCount) {
        this.bigPreallocCount = bigPreallocCount;
        return this;
    }

    public long statusInterval() {
        return statusInterval;
    }

    public BenchmarkOptions statusInterval(final long statusInterval) {
        this.statusInterval = statusInterval;
        return this;
    }

    public PrintStream out() {
        return out;
    }

    public BenchmarkOptions out(final PrintStream out) {
        this.out = out;
        return this;
    }

    public long gcSleep() {
        return gcSleep;
    }

    public BenchmarkOptions gcSleep(final long gcSleep) {
        this.gcSleep = gcSleep;
        return this;
    }

    public boolean shouldPrint() {
        if (out != null) {
            long now = System.currentTimeMillis();
            if (now - lastStatusTime > statusInterval) {
                lastStatusTime = now;
                return true;
            }
        }
        return false;
    }
}

