package ru.yandex.config.generator;

import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;

final class ConfigField {
    private final FieldType fieldType;
    private final String name;
    private final Type returnType;
    private final Type builderType;
    private final Type immutableType;
    private final Type defaultsType;

    public ConfigField(
        final FieldType fieldType,
        final String name,
        final Type returnType)
    {
        this.fieldType = fieldType;
        this.name = name;
        this.returnType = returnType;
        if (fieldType == FieldType.CONFIG) {
            builderType = new ClassOrInterfaceType(
                null,
                returnType.asString() + "Builder");
            immutableType = new ClassOrInterfaceType(
                null,
                "Immutable" + returnType.asString());
            defaultsType = new ClassOrInterfaceType(
                null,
                returnType.asString() + "Defaults");
        } else {
            builderType = returnType;
            immutableType = returnType;
            defaultsType = returnType;
        }
    }

    public FieldType fieldType() {
        return fieldType;
    }

    public String name() {
        return name;
    }

    public Type returnType() {
        return returnType;
    }

    public Type builderType() {
        return builderType;
    }

    public Type immutableType() {
        return immutableType;
    }

    public Type defaultsType() {
        return defaultsType;
    }

    public static String capitalize(final String name) {
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(name.charAt(0)));
        if (name.length() > 1) {
            result.append(name, 1, name.length());
        }

        return result.toString();
    }

}
