package ru.yandex.config.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;

public class ConfigGeneratorMain {
    public static void main(String[] args) throws Exception {
        File configFile = new File(args[0]);
        String configName  = configFile.getName().split("\\.")[0];
        CompilationUnit unit = JavaParser.parse(configFile);

        Config config =
            new Config(unit, configName, configFile.getParentFile());

        List<AbstractConfigGenerator> generators = new ArrayList<>();
        generators.add(new DefaultsConfigGenerator(config));
        generators.add(new AbstractBuilderConfigGenerator(config));
        generators.add(new ImmutableConfigGenerator(config));
        generators.add(new ConfigBuilderGenerator(config));

        for (AbstractConfigGenerator generator: generators) {
            generator.process();
        }
    }
}


