#!/bin/bash
source recommended-java-args.sh
source disk-config-base.sh

XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
GC_ARGS="-Xgcpolicy:gencon -verbose:gc -Xverbosegclog:/dev/shm/gc#.log,10,10000"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $MEM_ARGS $GC_ARGS \
    -cp dispatcher-zk.jar \
    ru.yandex.dispatcher.consumer.ConsumerServer -config \
    disk-callbacks-consumer.conf
