package ru.yandex.gate.mail;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.server.BaseServerConfigBuilder;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class Config extends ImmutableBaseServerConfig {
    private final String host;

    public Config(final IniConfig config) throws ConfigException {
        super(createConfig(config));
        IniConfig database = config.section("gatemail");
        host = database.getString("host", "");
    }

    private static ImmutableBaseServerConfig createConfig(final IniConfig ini)
        throws ConfigException
    {
        BaseServerConfigBuilder config = new BaseServerConfigBuilder(ini);
        config.name("gate-mail");
        LoggerConfigBuilder loggerConfig =
            new LoggerConfigBuilder(
                BackendAccessLoggerConfigDefaults.INSTANCE);
        loggerConfig.single().logFormat(
            BackendAccessLoggerConfigDefaults.INSTANCE
                .logFormat()
                + ProxyAccessLoggerConfigDefaults.LOG_FORMAT_SUFFIX
                + " %{"
                + SearchProxyAccessLoggerConfigDefaults.HITS_COUNT
                + '}');

        config.loggers().accessLoggers(
            LoggersConfigBuilder.loadLoggers(
                ini.section(LoggersConfigBuilder.ACCESSLOG),
                new PatternMap<>(loggerConfig)));
        return config.build();
    }

    public String host() {
        return host;
    }
}
