package ru.yandex.gate.mail;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;

public class ForwardedMessage {
    private static final CollectionParser<
        String,
        Set<String>,
        Exception>
        SET_PARSER = new CollectionParser<>(
            NonEmptyValidator.INSTANCE,
            LinkedHashSet::new);

    private String message;
    private String subject;
    private String from;
    private String to;
    private String msgTo;
    private String date;
    private String contentType;
    private List<String> headers;
    private Set<String> types;
    private Set<String> labels;
    private boolean raw;

    public ForwardedMessage(
        final CgiParams params,
        final String message)
        throws BadRequestException, IllegalArgumentException
    {
        from = params.getString("from");
        to = params.getString("to");
        msgTo = params.getString("msg-to", null);
        date = params.getString("date", null);
        subject = params.getString("subject");
        contentType = params.getString("content-type", null);
        raw = params.getBoolean("raw", false);
        types = params.getAll(
            "types",
            Collections.emptySet(),
            SET_PARSER);
        labels = params.getAll(
            "labels",
            Collections.emptySet(),
            SET_PARSER);
        if (!isTypes(types)) {
            throw new IllegalArgumentException("types are incorrect");
        }
        headers = params.getAll("header");
        if (headers == null) {
            headers = Collections.emptyList();
        }
        this.message = message;
    }

    public boolean hasHints() {
        return types.size() > 0 || labels.size() > 0;
    }

    public String getMessage() {
        return message;
    }

    public String getSubject() {
        return subject;
    }

    public Set<String> getTypes() {
        return types;
    }

    public Set<String> getLabels() {
        return labels;
    }

    public String getFrom() {
        return from;
    }

    public String getTo() {
        return to;
    }

    public String getDate() {
        return date;
    }

    public String getMsgTo() {
        return msgTo;
    }

    public List<String> getHeaders() {
        return headers;
    }

    public String getContentType() {
        return contentType;
    }

    public boolean raw() {
        return raw;
    }

    private boolean isTypes(final Set<String> types) {
        for (String type: types) {
            if (!type.matches("[0-9,]+")) {
                return false;
            }
        }
        return true;
    }
}
