package ru.yandex.gate.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

import ru.yandex.collection.Pattern;

import ru.yandex.http.server.sync.BaseHttpServer;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.request.RequestHandlerMapper;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.parser.uri.CgiParams;

public class Server
    extends BaseHttpServer<Config>
    implements HttpRequestHandler
{
    private static final String UTF8_STR = "UTF-8";
    private static String[][] rawTypesLable = {
        {"2", "registration"},
        {"4", "people"},
        {"5", "eticket"},
        {"6", "eshop"},
        {"7", "notification"},
        {"8", "bounce"},
        {"12", "greeting"},
        {"13", "news"},
        {"14", "s_grouponsite"},
        {"15", "s_datingsite"},
        {"16", "s_aviaeticket"},
        {"17", "s_bank"},
        {"18", "s_social"},
        {"19", "s_travel"},
        {"20", "s_zdticket"},
        {"21", "s_realty"},
        {"22", "personalnews"},
        {"23", "s_eshop"},
        {"24", "s_company"},
        {"25", "s_job"},
        {"26", "s_game"},
        {"27", "schema"},
        {"28", "cancel"},
        {"29", "s_tech"},
        {"30", "s_media"},
        {"31", "s_advert"},
        {"32", "s_provider"},
        {"33", "s_forum"},
        {"34", "s_mobile"},
        {"35", "hotel"},
        {"36", "yamoney"},
        {"37", "s_training"},
        {"38", "livemail"},
        {"39", "s_sender"},
        {"40", "phishing"},
        {"41", "s_tracker"},
        {"42", "invite"},
        {"43", "s_taxi"},
        {"44", "s_delivery"},
        {"45", "s_state"},
        {"46", "firstmail"},
        {"47", "s_news"},
        {"48", "s_event"},
        {"49", "edoc"},
        {"51", "trust_1"},
        {"52", "trust_2"},
        {"53", "trust_3"},
        {"54", "trust_4"},
        {"55", "trust_5"},
        {"56", "trust_6"},
        {"57", "s_seo"},
        {"58", "s_insurance"},
        {"59", "reminder"},
        {"60", "boardingpass"},
        {"61", "trackertask"},
        {"62", "discount"},
        {"63", "remind_tic"}};
    private static Map<Integer, String> typesMap;

    static {
        typesMap = new HashMap<>();
        for (int i = 0; i < rawTypesLable.length; ++i) {
            int key = Integer.parseInt(rawTypesLable[i][0]);
            String value = rawTypesLable[i][1];
            typesMap.put(key, value);
        }
    }

    public Server(final Config config) throws IOException {
        super(config);
        register(
            new Pattern<>("/send-mail", false),
            this,
            RequestHandlerMapper.POST);
    }

    @Override
    public void start() throws IOException {
        super.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public Map<String, Object> status(final boolean verbose) {
        Map<String, Object> status = super.status(verbose);
        return status;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        syncHandle(request, response, context);
    }

    private void syncHandle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        try {
            ForwardedMessage msg = new ForwardedMessage(
                new CgiParams(request),
                getPostData(request));
            String mailHost = config.host();
            SMTP mail = new SMTP(mailHost, logger());
            mail.send(msg);
            response.setStatusCode(HttpStatus.SC_OK);
        } catch (IllegalArgumentException e) {
            logger().log(Level.SEVERE, "Incorrect param: ", e);
            response.setStatusCode(HttpStatus.SC_BAD_REQUEST);
            response.setEntity(new StringEntity(
                e.getMessage(),
                CharsetUtils.acceptedCharset(request)));
        }
    }

    private static String getPostData(final HttpRequest request)
        throws IOException
    {
        String data = "";
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity =
                ((HttpEntityEnclosingRequest) request).getEntity();
            data = new String(EntityUtils.toByteArray(entity), UTF8_STR);
        }
        return data;
    }

    public static void main(final String... args)
        throws ConfigException, IOException
    {
        main(new ServerFactory(), args);
    }

    private static class SMTP {
        private static final int SMTP_PORT = 1234;
        private static final String TYPES_HEAD = "X-Yandex-Hint: ";
        private final Logger logger;
        private InetAddress mailHost;

        SMTP(
            final String host,
            final Logger logger)
            throws UnknownHostException
        {
            mailHost = InetAddress.getByName(host);
            this.logger = logger;
        }

        public boolean send(final ForwardedMessage msg) throws IOException {
            Socket smtpPipe;
            smtpPipe = new Socket(mailHost, SMTP_PORT);
            try (InputStream inn = smtpPipe.getInputStream();
                 OutputStream outt = smtpPipe.getOutputStream();
                 BufferedReader in = new BufferedReader(
                     new InputStreamReader(inn, UTF8_STR));
                 PrintWriter out = new PrintWriter(
                     new OutputStreamWriter(outt, UTF8_STR), true))
            {
                in.readLine();
                out.println("lhlo iex-proxy");
                for (int i = 0; i < 2 * 2; ++i) {
                    in.readLine();
                }
                out.println("MAIL FROM:<" + msg.getFrom() + '>');
                in.readLine();
                out.println("RCPT TO:<" + msg.getTo() + '>');
                in.readLine();
                out.println("data");
                in.readLine();
//                addTypes(out, msg.getTypes());
                if (msg.hasHints()) {
                    out.println(xYandexHint(msg));
                }
                out.println("From: " + msg.getFrom());
                if (msg.getMsgTo() != null) {
                    out.println("To: " + msg.getMsgTo());
                }
                if (msg.getDate() != null) {
                    out.println("Date: " + msg.getDate());
                }
                if (msg.getHeaders() != null) {
                    for (String header: msg.getHeaders()) {
                        logger.info("Sending header: " + header);
                        out.println(header);
                    }
                }
                if (msg.getContentType() != null) {
                    out.println("Content-type: " + msg.getContentType());
                } else {
                    out.println("Content-Type: text/html;charset=UTF-8");
                    out.println("Content-Transfer-Encoding: base64");
                }
                out.println("Subject: " + msg.getSubject());
                out.println("");
                if (msg.raw()) {
                    out.println(msg.getMessage());
                } else {
                    out.println(base64(msg.getMessage()));
                }
                out.println(".");
                in.readLine();
                out.println("quit");
                return true;
            }
        }

        private String xYandexHint(final ForwardedMessage msg)
            throws UnsupportedEncodingException
        {
            StringBuilder sb = new StringBuilder();
            for (String type: msg.getTypes()) {
                int iType = Integer.parseInt(type);
                String label = typesMap.get(iType);
                sb.append("label=SystMetkaSO:");
                sb.append(label);
                sb.append('\n');
            }
            for (String label: msg.getLabels()) {
                sb.append("label=symbol:");
                sb.append(label);
            }
            return TYPES_HEAD + base64(new String(sb));
        }

        private String base64(final String message)
            throws UnsupportedEncodingException
        {
            byte[] encodedBytes =
                Base64.getEncoder().encode(message.getBytes(UTF8_STR));
            return new String(encodedBytes, UTF8_STR);
        }
    }
}
