package ru.yandex.search.tts.gorgophone;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;

import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractGorgophoneConfigBuilder
    <T extends AbstractGorgophoneConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements GorgophoneConfig
{
    private HttpHostConfigBuilder backendConfig;
    private HttpHostConfigBuilder searchConfig;

    protected AbstractGorgophoneConfigBuilder(final GorgophoneConfig config) {
        super(config);
        backendConfig = new HttpHostConfigBuilder(config.backendConfig());
        searchConfig = new HttpHostConfigBuilder(config.searchConfig());
    }

    protected AbstractGorgophoneConfigBuilder(
        final IniConfig config,
        final GorgophoneConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        backendConfig = new HttpHostConfigBuilder(
            config.section("backend"),
            defaults.backendConfig());
        searchConfig = new HttpHostConfigBuilder(
            config.section("backend_search"),
            defaults.searchConfig());
    }

    @Override
    public HttpHostConfigBuilder backendConfig() {
        return backendConfig;
    }

    public T backendConfig(final HttpHostConfig backendConfig) {
        this.backendConfig = new HttpHostConfigBuilder(backendConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder searchConfig() {
        return searchConfig;
    }

    public T searchConfig(final HttpHostConfig config) {
        this.searchConfig = new HttpHostConfigBuilder(config);
        return self();
    }
}
