package ru.yandex.search.tts.gorgophone;

import java.text.ParseException;

import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.search.result.SearchDocument;

public class AddPropertyRecordHandler
    extends AddRecordHandlerBase<PropertyRecordContext>
{
    public AddPropertyRecordHandler(final Gorgophone server) {
        super(server);
    }

    @Override
    protected PropertyRecordContext createRecord(
        final ProxySession session,
        final long queueId)
        throws BadRequestException
    {
        return new PropertyRecordContext(session.params(), queueId);
    }

    @Override
    protected PropertyRecordContext recordFromDocument(final SearchDocument doc)
        throws ParseException
    {
        return new PropertyRecordContext(doc);
    }
}
