package ru.yandex.search.tts.gorgophone;

import java.io.IOException;

import java.text.ParseException;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.result.SearchDocument;

public class EntityRecordContext
    extends AbstractRecordContext<EntityRecordContext, EntityLuceneFields>
{
    public static final EntityLuceneFields FIELD_MAP = new EntityLuceneFields();
    public static final String KIND = "kind";
    public static final String DISPLAY_NAME = "display-name";
    public static final String SEMANTIC_ACTION = "semantic-action";
    public static final String DESCRIPTION = "description";
    public static final String ENTITY_ID = "entity-id";

    private final String entityId;
    private final String displayName;
    private final String kind;
    private final String semanticAction;
    private final String description;

    public EntityRecordContext(final CgiParams params)
        throws BadRequestException
    {
        super(params, FIELD_MAP);
        displayName = params.getString(DISPLAY_NAME);
        kind = params.getString(KIND);
        semanticAction = params.getString(SEMANTIC_ACTION);
        description = params.getString(DESCRIPTION);
        entityId = params.getString(ENTITY_ID);
    }

    public EntityRecordContext(final CgiParams params, final long queueId)
        throws BadRequestException
    {
        super(params, queueId, FIELD_MAP);
        displayName = params.getString(DISPLAY_NAME);
        kind = params.getString(KIND);
        semanticAction = params.getString(SEMANTIC_ACTION);
        description = params.getString(DESCRIPTION);
        entityId = params.getString(ENTITY_ID);
    }

    public EntityRecordContext(final SearchDocument doc) throws ParseException {
        super(doc, FIELD_MAP);
        displayName = doc.attrs().get(FIELD_MAP.displayName());
        kind = doc.attrs().get(FIELD_MAP.kind());
        semanticAction = doc.attrs().get(FIELD_MAP.semanticAction());
        description = doc.attrs().get(FIELD_MAP.description());
        entityId = doc.attrs().get(FIELD_MAP.entityId());
    }

    protected EntityRecordContext(
        final EntityRecordContext old,
        final EntityRecordContext current)
    {
        super(old, current);
        displayName = current.displayName;
        kind = current.kind;
        semanticAction = current.semanticAction;
        description = current.description;
        entityId = current.entityId;
    }

    @Override
    public String shardingField() {
        return entityId;
    }

    @Override
    public void appendCgiParams(final QueryConstructor qc)
        throws BadRequestException
    {
        qc.append(ENTITY_ID, entityId);
        qc.append(DISPLAY_NAME, displayName);
        qc.append(KIND, kind);
        qc.append(SEMANTIC_ACTION, semanticAction);
        qc.append(DESCRIPTION, description);
    }

    @Override
    public void writeFields(
        final JsonWriter writer,
        final EntityLuceneFields fieldMap)
        throws IOException
    {
        writer.key(fieldMap.displayName());
        writer.value(displayName);
        writer.key(fieldMap.kind());
        writer.value(kind);
        writer.key(fieldMap.semanticAction());
        writer.value(semanticAction);
        writer.key(fieldMap.description());
        writer.value(description);
        writer.key(fieldMap.entityId());
        writer.value(entityId);
    }

    @Override
    public EntityRecordContext adjust(final EntityRecordContext old) {
        return new EntityRecordContext(old, this);
    }

    @Override
    public String id() {
        return entityId;
    }

    public String entityId() {
        return entityId;
    }

    public String displayName() {
        return displayName;
    }

    public String kind() {
        return kind;
    }

    public String semanticAction() {
        return semanticAction;
    }

    public String description() {
        return description;
    }
}
