package ru.yandex.search.tts.gorgophone;

import java.io.IOException;

import java.security.GeneralSecurityException;

import org.apache.http.HttpException;

import ru.yandex.collection.Pattern;

import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.proxy.StaticProxyHandler;

import ru.yandex.http.util.nio.client.AsyncClient;

public class Gorgophone extends HttpProxy<ImmutableGorgophoneConfig> {
    private final AsyncClient backendClient;
    private final AsyncClient searchClient;

    public Gorgophone(final ImmutableGorgophoneConfig config)
        throws GeneralSecurityException,
            HttpException,
            IOException
    {
        super(config);

        backendClient = client("Backend", config.backendConfig());
        searchClient = client("Search", config.searchConfig());

        register(
            new Pattern<>("/AddEntityRecord", false),
            new AddEntityRecordHandler(this));
        register(
            new Pattern<>("/add-entity-record", false),
            new AddEntityRecordHandler(this));

        register(
            new Pattern<>("/AddPropertyRecord", false),
            new AddPropertyRecordHandler(this));
        register(
            new Pattern<>("/add-property-record", false),
            new AddPropertyRecordHandler(this));

        register(
            new Pattern<>("/AddRelationshipRecord", false),
            new AddRelationshipRecordHandler(this));
        register(
            new Pattern<>("/add-relationship-record", false),
            new AddRelationshipRecordHandler(this));

        register(
            new Pattern<>("/searcher/", true),
            new StaticProxyHandler(
                searchClient,
                config.searchConfig().host()));

        register(
            new Pattern<>("", true),
            new StaticProxyHandler(
                backendClient,
                config.backendConfig().host()));
    }

    public AsyncClient backendClient() {
        return backendClient;
    }

    public AsyncClient searchClient() {
        return searchClient;
    }
}
