package ru.yandex.search.tts.gorgophone;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class GorgophoneConfigBuilder
    extends AbstractGorgophoneConfigBuilder<GorgophoneConfigBuilder>
{
    public GorgophoneConfigBuilder() {
        super(GorgophoneConfigDefaults.INSTANCE);
    }

    public GorgophoneConfigBuilder(final GorgophoneConfig config) {
        super(config);
    }

    public GorgophoneConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, GorgophoneConfigDefaults.INSTANCE);
    }

    public GorgophoneConfigBuilder(
        final IniConfig config,
        final GorgophoneConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public GorgophoneConfigBuilder self() {
        return this;
    }

    public ImmutableGorgophoneConfig build() throws ConfigException {
        return new ImmutableGorgophoneConfig(this);
    }
}

