package ru.yandex.search.tts.gorgophone;

import ru.yandex.http.config.ImmutableHttpHostConfig;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableGorgophoneConfig
    extends ImmutableHttpProxyConfig
    implements GorgophoneConfig
{
    private final ImmutableHttpHostConfig backendConfig;
    private final ImmutableHttpHostConfig searchConfig;

    public ImmutableGorgophoneConfig(final GorgophoneConfig config)
        throws ConfigException
    {
        super(config);
        backendConfig = new ImmutableHttpHostConfig(config.backendConfig());
        searchConfig = new ImmutableHttpHostConfig(config.searchConfig());
    }

    @Override
    public ImmutableHttpHostConfig backendConfig() {
        return backendConfig;
    }

    @Override
    public ImmutableHttpHostConfig searchConfig() {
        return searchConfig;
    }
}
