package ru.yandex.junk;

import java.text.DecimalFormat;
import java.util.Random;

import ru.yandex.msearch.util.Compress;
import ru.yandex.unsafe.NativeMemory2;

public class CompressorsTest {
    private static final NativeMemory2.NativeMemoryAllocator allocator =
        NativeMemory2.NativeMemoryAllocator.get("test");

    public static void main(String[] args) throws Exception {
        final int cycles = 10000;
        int[] blockSizes = { 1024, 2048, 4096, 8192, 16384, 32768, 65536,
            131072 };
        int[] randomness = { 5, 10, 12 };

        System.out.println("Testing zlib");
        for (int s = 0; s < blockSizes.length; s++) {
            final int blockSize = blockSizes[s];
            System.out.println("Testing block size=" + blockSize);
            for (int r = 0; r < randomness.length; r++) {
                final int rnd = randomness[r];
                System.out.println("rnd(" + rnd + "): "
                    + testZlibBlock(blockSize, rnd, cycles));
            }
        }

        System.out.println("\n\nTesting zstd");
        for (int s = 0; s < blockSizes.length; s++) {
            final int blockSize = blockSizes[s];
            System.out.println("Testing block size=" + blockSize);
            for (int r = 0; r < randomness.length; r++) {
                final int rnd = randomness[r];
                System.out.println("rnd(" + rnd + "): "
                    + testZstdBlock(blockSize, rnd, cycles));
            }
        }
    }

    private static Results testZlibBlock(final int blockSize, final int randomness,
        final int cycles)
    {
        final long data = allocator.allocUnboxed(blockSize);
        final long compressedData = allocator.allocUnboxed(blockSize << 1);
        fillData(data, blockSize, randomness);

        try {
            final int compressedSize = Compress.zlibCompressBlock(data, blockSize,
                compressedData, blockSize << 1);
            if (compressedSize < 0) {
                throw new RuntimeException("zlib compression error");
            }

            long startTime = System.currentTimeMillis();
            for (int i = 0; i < cycles; i++) {
                int ret = Compress.zlibDecompressBlock(compressedData, compressedSize,
                    data, blockSize);
                if (ret < 0) {
                    throw new RuntimeException("zlib decompression error");
                }
            }
            long time = System.currentTimeMillis() - startTime;
            return new Results(time, (double)blockSize / (double)compressedSize);
        } finally {
            allocator.freeUnboxed(data);
            allocator.freeUnboxed(compressedData);
        }
    }

    private static Results testZstdBlock(final int blockSize, final int randomness,
        final int cycles)
    {
        final long data = allocator.allocUnboxed(blockSize);
        final long compressedData = allocator.allocUnboxed(blockSize << 1);
        fillData(data, blockSize, randomness);

        try {
            final int compressedSize = Compress.zstdCompressBlock(data, blockSize,
                compressedData, blockSize << 1);
            if (compressedSize < 0) {
                throw new RuntimeException("zlib compression error");
            }

            long startTime = System.currentTimeMillis();
            for (int i = 0; i < cycles; i++) {
                int ret = Compress.zstdDecompressBlock(compressedData, compressedSize,
                    data, blockSize);
                if (ret < 0) {
                    throw new RuntimeException("zlib decompression error");
                }
            }
            long time = System.currentTimeMillis() - startTime;
            return new Results(time, (double)blockSize / (double)compressedSize);
        } finally {
            allocator.freeUnboxed(data);
            allocator.freeUnboxed(compressedData);
        }
    }

    private static void fillData(final long ptr, final int size,
        int randomness)
    {
        Random rnd = new Random(100500L);
        if (randomness > 100) {
            randomness = 100;
        }
        int repe = 100 / randomness;
        for (int i = 0; i < size; i++) {
            byte b = (byte)(127 - rnd.nextInt(256));
            int r = repe;
            while (r-- > 0 && i < size) {
                NativeMemory2.unboxedSetByte(ptr + i++, b);
            }
        }
    }

    static class Results {
        public final long time;
        public final double ratio;

        public Results(final long time, final double ratio) {
            this.time = time;
            this.ratio = ratio;
        }

        @Override
        public String toString() {
            return "time=" + time + " ms"
                + ", ratio=" + new DecimalFormat("0.00").format(ratio);
        }
    }
}
