#!/bin/bash
set -exo pipefail

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.
export MAJOR_HOSTNAME=`hostname -f`
XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M -Xmn512M"
GC_ARGS="-XX:+UnlockExperimentalVMOptions -XX:+UseZGC -XX:ConcGCThreads=4 -XX:ParallelGCThreads=8 -XX:+DisableExplicitGC -Xlog:gc*:/logs/gc.log"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk-11/bin/java \
    $MEM_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=. \
    -DHOSTNAME=$MAJOR_HOSTNAME \
    -cp major.jar \
    ru.yandex.major.Major \
    major.conf

