package ru.yandex.major;

import java.io.IOException;

import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.IntPair;

import ru.yandex.http.util.EmptyFutureCallback;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.StatusCodeAsyncConsumerFactory;

import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.util.string.StringUtils;

public class BasicStorageUpdatesConsumer implements StorageUpdatesConsumer {
    private static final String URL = "url";
    private static final String SERVICE = "change_log";
    private static final String YUIDS = "yuids";
    private static final String FUNCTION = "function";
    private static final String ARGS = "args";

    private final Major major;

    public BasicStorageUpdatesConsumer(final Major major) {
        this.major = major;
    }

    @Override
    public Future<IntPair<Void>> yuids(
        final long uid,
        final Set<String> yuids)
    {
        major.yuidsUpdates().accept(1L);
        String yuidsStr = StringUtils.join(yuids, '\n');
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.NORMAL.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(uid);
            writer.key("AddIfNotExists");
            writer.value("true");
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key(URL);
            writer.value("user_gbl_" + uid);
            writer.key(YUIDS);
            writer.startObject();
            writer.key(FUNCTION);
            writer.value("make_set");
            writer.key(ARGS);
            writer.startArray();
            writer.value(yuidsStr);
            writer.startObject();
            writer.key(FUNCTION);
            writer.value("get");
            writer.key(ARGS);
            writer.startArray();
            writer.value(YUIDS);
            writer.endArray();
            writer.endObject();
            writer.endArray();
            writer.endObject();
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            this.major.logger().log(
                Level.WARNING,
                "Failed to create yuids update for " + uid + ' ' + yuids,
                e);
            return null;
        }

        StringBuilder uri = new StringBuilder("/update?&yuids&prefix=");
        uri.append(uid);
        uri.append("&service=");
        uri.append(SERVICE);

        return major.producerClient().execute(
            major.producerHost(),
            new BasicAsyncRequestProducerGenerator(
                uri.toString(),
                sbw.toString()),
            StatusCodeAsyncConsumerFactory.ANY_GOOD,
            new ProducerCallback(uri.toString(), sbw.toString()));
    }

    @Override
    public Future<IntPair<Void>> online(
        final long uid,
        final long ts,
        final long ctime)
    {
        long lag = ctime - ts;
        if (lag <= major.config().notificationSendLagThreshold()) {
            return notify(uid);
        }

        return null;
    }

    public Future<IntPair<Void>> notify(final long uid) {
        major.onlineTransfer().accept(1L);
        return major.msearchProxyClient().execute(
            major.msearchProxyHost(),
            new BasicAsyncRequestProducerGenerator(
                "/api/async/enlarge/your?uid=" + uid),
            StatusCodeAsyncConsumerFactory.ANY_GOOD,
            EmptyFutureCallback.INSTANCE);
    }

    private final class ProducerCallback
        implements FutureCallback<IntPair<Void>>
    {
        private final String uri;
        private final String payload;

        private ProducerCallback(final String uri, final String payload) {
            this.uri = uri;
            this.payload = payload;
        }

        @Override
        public void completed(final IntPair<Void> o) {
        }

        @Override
        public void failed(final Exception e) {
            major.logger().log(
                Level.WARNING,
                "Producer request failed " + uri + ' ' + payload,
                e);
        }

        @Override
        public void cancelled() {
            major.logger().warning(
                "Producer request cancelled " + uri + ' ' + payload);
        }
    }
}
