package ru.yandex.major;

import java.io.IOException;

import java.util.Collection;
import java.util.Set;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.stater.Stater;

public interface Storage extends GenericAutoCloseable<IOException>, Stater {
    enum PutStatus {
        UPDATED,
        CREATED,
        NOT_CHANGED
    }

    PutStatus put(
        final long uid,
        final long ts,
        final Collection<String> yuids);

    PutStatus putQuiet(
        final long uid,
        final long ts,
        final Collection<String> yuids);

    boolean online(final long uid);

    long lastSeen(final long uid);

    Set<String> yuids(final long uid);

    void start();
}
