package ru.yandex.major;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;

import org.apache.http.message.BasicHeader;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.io.StringBuilderWriter;

import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

public class UserInfoHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private enum GET {
        ONLINE,
        TS,
        YUIDS
    }

    private final Major major;
    private final Storage storage;

    public UserInfoHandler(
        final Major major,
        final Storage storage)
        throws IOException
    {
        this.storage = storage;
        this.major = major;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        CgiParams params = new CgiParams(request);
        long uid = params.getLong("uid");
        if (!major.userOnCurrentHost(uid)) {
            List<HttpHost> hosts = new ArrayList<>(major.userHosts(uid));
            Collections.shuffle(hosts);

            if (hosts.size() <= 0) {
                throw new NotFoundException("User not found " + uid);
            }

            BasicAsyncResponseProducerGenerator generator =
                new BasicAsyncResponseProducerGenerator(
                    HttpStatus.SC_TEMPORARY_REDIRECT);

            UriParser parser = new UriParser(request.getRequestLine().getUri());
            generator.addHeader(
                HttpHeaders.LOCATION,
                hosts.get(0).toURI() + parser.toString());
            exchange.submitResponse(generator.get());
            return;
        }

        Set<GET> get =
            params.get(
                "get",
                Collections.singleton(GET.ONLINE),
                new CollectionParser<>(
                    new EnumParser<>(GET.class),
                    HashSet::new));

        List<Header> headers = Collections.emptyList();
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer =
                 JsonTypeExtractor.NORMAL.extract(params).create(sbw))
        {
            writer.startObject();
            if (get.contains(GET.ONLINE)) {
                boolean onlineStatus = storage.online(uid);
                writer.key("online");
                writer.value(onlineStatus);
                String stringStatus;

                if (onlineStatus) {
                    stringStatus = "Online";
                } else {
                    stringStatus = "Offline";
                }

                headers =
                    Collections.singletonList(
                        new BasicHeader("Status", stringStatus));
            }

            if (get.contains(GET.TS)) {
                writer.key("seen");
                writer.value(storage.lastSeen(uid));
            }

            if (get.contains(GET.YUIDS)) {
                writer.key("yuids");
                writer.value(storage.yuids(uid));
            }

            writer.endObject();
        }

        BasicAsyncResponseProducerGenerator respGenerator =
            new BasicAsyncResponseProducerGenerator(
                HttpStatus.SC_OK,
                sbw.toString());

        headers.forEach(respGenerator::addHeader);

        exchange.submitResponse(respGenerator.get());
    }
}
