package ru.yandex.major;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.EmptyFutureCallback;

import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;

import ru.yandex.json.parser.JsonException;

public class UserUpdateHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final String YUIDS = "yuids";
    private final Major major;
    private final Storage storage;

    public UserUpdateHandler(final Major major, final Storage storage) {
        this.major = major;
        this.storage = storage;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    private Map<Long, UserData> parse(
        final String content)
        throws JsonException
    {
        JsonMap map = TypesafeValueContentHandler.parse(content).asMap();
        Map<Long, UserData> users = new HashMap<>(map.size());
        for (Map.Entry<String, JsonObject> entry: map.entrySet()) {
            Long uid = Long.parseLong(entry.getKey());
            JsonMap data = entry.getValue().asMap();
            Long ts = data.getLong("ts");
            JsonList yuidsJsonList = data.getList(YUIDS);
            List<String> yuids;
            if (yuidsJsonList.size() <= 0) {
                yuids = Collections.emptyList();
            } else {
                yuids = new ArrayList<>(yuidsJsonList.size());
                for (JsonObject yuid: yuidsJsonList) {
                    yuids.add(yuid.asString());
                }
            }

            users.put(uid, new UserData(ts, yuids));
        }

        return users;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("No payload in request");
        }

        String content =
            CharsetUtils.toString(
                ((HttpEntityEnclosingRequest) request).getEntity());

        Map<Long, UserData> batch;
        try {
            batch = parse(content);
        } catch (JsonException | NumberFormatException e) {
            throw new BadRequestException(e);
        }

        ProxySession session = new BasicProxySession(major, exchange, context);

        Long uid = session.params().getLong("prefix");

        Set<HttpHost> hosts = major.userHosts(uid);
        if (!major.userOnCurrentHost(uid)) {
            session.logger().warning(
                "User " + uid
                    + " not belongs to this host forwarding to " + hosts);
            if (hosts.size() <= 0) {
                throw new NotFoundException("User not found in searchmap");
            }

            HttpHost host = hosts.iterator().next();
            BasicAsyncResponseProducerGenerator generator =
                new BasicAsyncResponseProducerGenerator(
                    HttpStatus.SC_TEMPORARY_REDIRECT);

            generator.addHeader(
                HttpHeaders.LOCATION,
                host.toURI() + session.uri());
            session.response(generator.get());
        } else {
            boolean finalRequest =
                session.params().getBoolean("final", false);
            if (!finalRequest) {
                List<HttpHost> hostsList = new ArrayList<>(hosts);
                hostsList.remove(major.currentHost());

                major.indexerClient().adjust(session.context()).execute(
                    hostsList,
                    new BasicAsyncRequestProducerGenerator(
                        session.uri().toString() + "&final", content),
                    EmptyAsyncConsumerFactory.ANY_GOOD,
                    session.listener().createContextGeneratorFor(
                        major.indexerClient()),
                    EmptyFutureCallback.INSTANCE);
            }

            for (Map.Entry<Long, UserData> entry
                : batch.entrySet())
            {
                if (finalRequest) {
                    storage.putQuiet(
                        entry.getKey(),
                        entry.getValue().ts(),
                        entry.getValue().yuids());
                } else {
                    storage.put(
                        entry.getKey(),
                        entry.getValue().ts(),
                        entry.getValue().yuids());
                }
            }
        }

        session.response(HttpStatus.SC_OK);
    }
}
