package ru.yandex.major;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.HttpStatus;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;

import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.collection.IntPair;

import ru.yandex.http.proxy.BasicProxySession;

public class YuidsUpdateHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final Major major;
    private final StorageUpdatesConsumer consumer;

    public YuidsUpdateHandler(
        final Major major,
        final StorageUpdatesConsumer consumer)
    {
        this.major = major;
        this.consumer = consumer;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        BasicProxySession session =
            new BasicProxySession(major, exchange, context);
        long uid = session.params().getLong("uid");
        List<String> yuids = session.params().getAll("yuid");
        Future<IntPair<Void>> future =
            consumer.yuids(uid, new HashSet<>(yuids));
        int code = HttpStatus.SC_BAD_GATEWAY;
        try {
            code = future.get().first();
        } catch (InterruptedException | ExecutionException e) {
            session.logger().log(Level.WARNING, "Failed update yuids", e);
        } finally {
            session.response(code);
        }
    }
}
