package ru.yandex.major.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.search.proxy.ImmutableSearchProxyConfig;

public class ImmutableMajorConfig
    extends ImmutableSearchProxyConfig
    implements MajorConfig
{
    private final ImmutableHttpHostConfig proxyConfig;
    private final ImmutableHttpHostConfig producerConfig;
    private final ImmutableStorageConfig storageConfig;
    private final int notificationSendLagThreshold;

    public ImmutableMajorConfig(
        final MajorConfig config)
        throws ConfigException
    {
        super(config);

        this.proxyConfig = new ImmutableHttpHostConfig(config.proxyConfig());
        this.producerConfig =
            new ImmutableHttpHostConfig(config.producerConfig());

        this.storageConfig = new ImmutableStorageConfig(config.storageConfig());
        this.notificationSendLagThreshold =
            config.notificationSendLagThreshold();
    }

    @Override
    public ImmutableHttpHostConfig proxyConfig() {
        return proxyConfig;
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public ImmutableStorageConfig storageConfig() {
        return storageConfig;
    }

    @Override
    public int notificationSendLagThreshold() {
        return notificationSendLagThreshold;
    }
}
