package ru.yandex.major.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableStorageConfig
    implements StorageConfig
{
    private final int storageExpireTime;
    private final int initialStorageSize;
    private final int maximumCapacity;
    private final String dumpPath;
    private final int dumpPeriod;

    public ImmutableStorageConfig(
        final StorageConfig config)
        throws ConfigException
    {
        this.storageExpireTime = config.storageExpireTime();
        this.initialStorageSize = config.initialStorageSize();
        this.maximumCapacity = config.maximumCapacity();
        this.dumpPath = config.dumpPath();
        this.dumpPeriod = config.dumpPeriod();
    }

    @Override
    public int storageExpireTime() {
        return storageExpireTime;
    }

    @Override
    public int initialStorageSize() {
        return initialStorageSize;
    }

    @Override
    public String dumpPath() {
        return this.dumpPath;
    }

    @Override
    public int dumpPeriod() {
        return dumpPeriod;
    }

    @Override
    public int maximumCapacity() {
        return maximumCapacity;
    }
}
