package ru.yandex.major.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.search.proxy.AbstractSearchProxyConfigBuilder;

public class MajorConfigBuilder
    extends AbstractSearchProxyConfigBuilder<MajorConfigBuilder>
    implements MajorConfig
{
    private HttpHostConfigBuilder proxyConfig;
    private HttpHostConfigBuilder producerConfig;
    private StorageConfigBuilder storageConfig;

    private int notificationSendLagThreshold;

    public MajorConfigBuilder(final MajorConfig config) {
        super(config);

        this.storageConfig(config.storageConfig());
        this.proxyConfig(config.proxyConfig());
        this.producerConfig(config.producerConfig());
        this.notificationSendLagThreshold(
            config.notificationSendLagThreshold());
    }

    public MajorConfigBuilder(final IniConfig config) throws ConfigException {
        this(config, MajorConfigDefaults.INSTANCE);
    }

    public MajorConfigBuilder(
        final IniConfig config,
        final MajorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        this.proxyConfig =
            new HttpHostConfigBuilder(
                config.section("proxy"),
                defaults.proxyConfig());
        this.producerConfig =
            new HttpHostConfigBuilder(
                config.section("producer"),
                defaults.producerConfig());

        this.storageConfig =
            new StorageConfigBuilder(
                config.section("storage"),
                defaults.storageConfig());

        this.notificationSendLagThreshold =
            config.get(
                "notification-lag-threshold",
                defaults.notificationSendLagThreshold(),
                PositiveIntegerValidator.INSTANCE);
    }

    public HttpHostConfigBuilder proxyConfig() {
        return proxyConfig;
    }

    public MajorConfigBuilder proxyConfig(final HttpHostConfig proxyConfig) {
        this.proxyConfig = new HttpHostConfigBuilder(proxyConfig);
        return self();
    }

    public HttpHostConfigBuilder producerConfig() {
        return producerConfig;
    }

    public MajorConfigBuilder producerConfig(
        final HttpHostConfig producerConfig)
    {
        this.producerConfig = new HttpHostConfigBuilder(producerConfig);
        return this;
    }

    @Override
    public StorageConfigBuilder storageConfig() {
        return storageConfig;
    }

    public MajorConfigBuilder storageConfig(
        final StorageConfig config)
    {
        this.storageConfig = new StorageConfigBuilder(config);
        return this;
    }

    @Override
    public MajorConfigBuilder self() {
        return this;
    }

    public ImmutableMajorConfig build() throws ConfigException {
        return new ImmutableMajorConfig(this);
    }

    @Override
    public int notificationSendLagThreshold() {
        return notificationSendLagThreshold;
    }

    public MajorConfigBuilder notificationSendLagThreshold(
        final int thrsh)
    {
        this.notificationSendLagThreshold = thrsh;
        return self();
    }
}
