package ru.yandex.major.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.search.proxy.SearchProxyConfigDefaults;

public class MajorConfigDefaults
    extends SearchProxyConfigDefaults
    implements MajorConfig
{
    public static final MajorConfigDefaults INSTANCE
        = new MajorConfigDefaults();

    private static final int DEFAULT_THRSH = 10000;

    @Override
    public HttpHostConfig proxyConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig producerConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public StorageConfig storageConfig() {
        return StorageConfigDefaults.INSTANCE;
    }

    @Override
    public int notificationSendLagThreshold() {
        return DEFAULT_THRSH;
    }
}
