package ru.yandex.major.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.PositiveIntegerValidator;

public class StorageConfigBuilder
    implements StorageConfig
{
    private int storageExpireTime;
    private int initialStorageSize;
    private int maximumCapacity;
    private int dumpPeriod;

    private String dumpPath;

    public StorageConfigBuilder() {
        this(StorageConfigDefaults.INSTANCE);
    }

    public StorageConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, StorageConfigDefaults.INSTANCE);
    }

    public StorageConfigBuilder(
        final StorageConfig config)
    {
        this.storageExpireTime(config.storageExpireTime());
        this.initialStorageSize(config.initialStorageSize());
        this.maximumCapacity(config.maximumCapacity());
        this.dumpPath(config.dumpPath());
        this.dumpPeriod(config.dumpPeriod());
    }

    public StorageConfigBuilder(
        final IniConfig config,
        final StorageConfig defaults)
        throws ConfigException
    {
        this.storageExpireTime =
            config.getInt("expire", defaults.storageExpireTime());
        this.dumpPath =
            config.getString("dump-path", defaults.dumpPath());
        this.initialStorageSize = config.get(
            "init-size",
            defaults.initialStorageSize(),
            PositiveIntegerValidator.INSTANCE);
        this.dumpPeriod =
            config.getIntegerDuration("dump-period", defaults.dumpPeriod());
        this.maximumCapacity = config.get(
            "capacity",
            defaults.maximumCapacity(),
            PositiveIntegerValidator.INSTANCE);
    }

    @Override
    public int storageExpireTime() {
        return storageExpireTime;
    }

    public StorageConfigBuilder storageExpireTime(
        final int seconds)
    {
        this.storageExpireTime = seconds;
        return this;
    }

    public ImmutableStorageConfig build() throws ConfigException {
        return new ImmutableStorageConfig(this);
    }

    @Override
    public int initialStorageSize() {
        return initialStorageSize;
    }

    public StorageConfigBuilder initialStorageSize(
        final int initialStorageSize)
    {
        this.initialStorageSize = initialStorageSize;
        return this;
    }

    @Override
    public String dumpPath() {
        return dumpPath;
    }

    public StorageConfigBuilder dumpPath(final String dumpPath) {
        this.dumpPath = dumpPath;
        return this;
    }

    @Override
    public int dumpPeriod() {
        return dumpPeriod;
    }

    public StorageConfigBuilder dumpPeriod(final int dumpPeriod) {
        this.dumpPeriod = dumpPeriod;
        return this;
    }

    @Override
    public int maximumCapacity() {
        return maximumCapacity;
    }

    public StorageConfigBuilder maximumCapacity(final int maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
        return this;
    }
}
